/*
 * Decompiled with CFR 0.152.
 */
package won.owner.protocol.message.base;

import java.net.URI;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.tdb.TDB;
import org.springframework.beans.factory.annotation.Autowired;
import won.owner.protocol.message.OwnerCallback;
import won.owner.protocol.message.base.OwnerCallbackAdapter;
import won.protocol.exception.DataIntegrityException;
import won.protocol.message.WonMessage;
import won.protocol.message.processor.exception.WonMessageProcessingException;
import won.protocol.model.Connection;
import won.protocol.model.ConnectionState;
import won.protocol.util.RdfUtils;
import won.protocol.util.linkeddata.LinkedDataSource;

public class DatasetBackedOwnerCallbackAdapter
extends OwnerCallbackAdapter {
    private static final String QUERY_CONNECTION = "SELECT ?con ?atom ?state ?remoteCon ?targetAtom ?type where {   ?con won:sourceAtom ?atom;      won:atomState ?state;      won:socket ?type;      won:targetAtom ?targetAtom.  OPTIONAL {     ?con won:targetConnection ?remoteCon  } } ";
    @Autowired
    private Dataset dataset;
    @Autowired
    private LinkedDataSource linkedDataSource;

    public DatasetBackedOwnerCallbackAdapter(OwnerCallback adaptee) {
        super(adaptee);
    }

    @Override
    public WonMessage process(WonMessage message) throws WonMessageProcessingException {
        RdfUtils.addDatasetToDataset((Dataset)this.dataset, (Dataset)message.getCompleteDataset());
        return super.process(message);
    }

    public void setLinkedDataSource(LinkedDataSource linkedDataSource) {
        this.linkedDataSource = linkedDataSource;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    @Override
    protected Connection makeConnection(WonMessage wonMessage) {
        URI connUri = wonMessage.getRecipientURI();
        ParameterizedSparqlString pss = new ParameterizedSparqlString();
        pss.setNsPrefix("won", "https://w3id.org/won/core#");
        pss.setCommandText(QUERY_CONNECTION);
        pss.setIri("con", connUri.toString());
        Query query = pss.asQuery();
        try (QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Dataset)this.dataset);){
            qExec.getContext().set(TDB.symUnionDefaultGraph, true);
            Connection con = null;
            ResultSet results = qExec.execSelect();
            if (results.hasNext()) {
                QuerySolution soln = results.next();
                if (results.hasNext()) {
                    throw new DataIntegrityException("Query must not yield multiple solutions");
                }
                con = new Connection();
                con.setConnectionURI(this.getURIFromSolution(soln, "con"));
                con.setTypeURI(this.getURIFromSolution(soln, "type"));
                con.setAtomURI(this.getURIFromSolution(soln, "atom"));
                con.setState(ConnectionState.fromURI((URI)this.getURIFromSolution(soln, "state")));
                con.setTargetAtomURI(this.getURIFromSolution(soln, "targetAtom"));
                con.setTargetConnectionURI(this.getURIFromSolution(soln, "remoteCon"));
            }
            Connection connection = con;
            return connection;
        }
    }

    private URI getURIFromSolution(QuerySolution soln, String var) {
        return URI.create(soln.getResource(var).getURI().toString());
    }
}

