/*
 * Decompiled with CFR 0.152.
 */
package won.owner.protocol.message;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.protocol.message.WonMessage;
import won.protocol.message.processor.WonMessageProcessor;
import won.protocol.message.processor.exception.WonMessageProcessingException;
import won.protocol.util.linkeddata.CachingLinkedDataSource;
import won.protocol.util.linkeddata.LinkedDataSource;

public class LinkedDataCacheUpdater
implements WonMessageProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    private LinkedDataSource linkedDataSourceOnBehalfOfAtom;

    public WonMessage process(WonMessage message) throws WonMessageProcessingException {
        if (this.linkedDataSourceOnBehalfOfAtom != null && this.linkedDataSourceOnBehalfOfAtom instanceof CachingLinkedDataSource) {
            logger.debug("putting message {} into cache", (Object)message.getMessageURI());
            URI requester = message.getRecipientAtomURI();
            ((CachingLinkedDataSource)this.linkedDataSourceOnBehalfOfAtom).addToCache(message.getCompleteDataset(), message.getMessageURI(), requester);
        }
        return message;
    }

    public void setLinkedDataSourceOnBehalfOfAtom(LinkedDataSource linkedDataSourceOnBehalfOfAtom) {
        this.linkedDataSourceOnBehalfOfAtom = linkedDataSourceOnBehalfOfAtom;
    }
}

