/*
 * Decompiled with CFR 0.152.
 */
package won.owner.protocol.message;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import org.apache.jena.query.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageType;
import won.protocol.message.processor.WonMessageProcessor;
import won.protocol.message.processor.exception.WonMessageProcessingException;
import won.protocol.util.AtomModelWrapper;
import won.protocol.util.linkeddata.CachingLinkedDataSource;
import won.protocol.util.linkeddata.LinkedDataSource;
import won.protocol.util.linkeddata.WonLinkedDataUtils;

public class LinkedDataCacheInvalidator
implements WonMessageProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private CachingLinkedDataSource linkedDataSource;
    private CachingLinkedDataSource linkedDataSourceOnBehalfOfAtom;

    public void setLinkedDataSource(CachingLinkedDataSource linkedDataSource) {
        this.linkedDataSource = linkedDataSource;
    }

    public void setLinkedDataSourceOnBehalfOfAtom(CachingLinkedDataSource linkedDataSourceOnBehalfOfAtom) {
        this.linkedDataSourceOnBehalfOfAtom = linkedDataSourceOnBehalfOfAtom;
    }

    public WonMessage process(WonMessage message) throws WonMessageProcessingException {
        WonMessageType type = message.getMessageType();
        if (type == WonMessageType.SUCCESS_RESPONSE) {
            type = message.getIsResponseToMessageType();
        }
        URI webId = message.getRecipientAtomURI();
        if (message.getRecipientURI() != null) {
            logger.debug("invalidating events list for atom " + message.getRecipientAtomURI() + " for connection " + message.getRecipientURI());
            URI messageContainerUri = WonLinkedDataUtils.getMessageContainerURIforConnectionURI((URI)message.getRecipientURI(), (LinkedDataSource)this.linkedDataSource);
            this.invalidate(messageContainerUri, webId);
            if (type.causesConnectionStateChange()) {
                this.invalidate(message.getRecipientURI(), webId);
            }
        }
        if (type.causesNewConnection()) {
            logger.debug("invalidating connections list for atom " + message.getRecipientAtomURI());
            Dataset atom = this.linkedDataSource.getDataForResource(message.getRecipientAtomURI());
            AtomModelWrapper wrapper = new AtomModelWrapper(atom);
            URI connectionsListUri = URI.create(wrapper.getConnectionContainerUri());
            this.invalidate(connectionsListUri, webId);
        }
        if (type.causesAtomStateChange()) {
            this.invalidate(message.getRecipientAtomURI(), webId);
        }
        return message;
    }

    private void invalidate(URI uri, URI webId) {
        if (uri == null) {
            return;
        }
        this.linkedDataSource.invalidate(uri);
        this.linkedDataSource.invalidate(uri, webId);
        if (this.linkedDataSourceOnBehalfOfAtom != this.linkedDataSource) {
            this.linkedDataSourceOnBehalfOfAtom.invalidate(uri);
            this.linkedDataSourceOnBehalfOfAtom.invalidate(uri, webId);
        }
    }
}

