/*
 * Decompiled with CFR 0.152.
 */
package won.owner.model;

import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import nl.martijndwars.webpush.Subscription;

@Entity
@Table(name="pushSubscriptions", uniqueConstraints={@UniqueConstraint(columnNames={"user_id", "endpoint"})})
public class PushSubscription {
    @Id
    @GeneratedValue
    @Column(name="id")
    private Long id;
    @Column(nullable=false)
    private String endpoint;
    @Column(nullable=false)
    private String key;
    @Column(nullable=false)
    private String auth;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    private Date updated;

    public PushSubscription() {
    }

    @PrePersist
    protected void onCreate() {
        this.updated = new Date();
    }

    protected void updateDate() {
        this.updated = new Date();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public PushSubscription(Subscription subscription) {
        this.endpoint = subscription.endpoint;
        this.key = subscription.keys.p256dh;
        this.auth = subscription.keys.auth;
    }

    public Subscription toSubscription() {
        return new Subscription(this.endpoint, new Subscription.Keys(this.key, this.auth));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushSubscription that = (PushSubscription)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

