/*
 * Decompiled with CFR 0.152.
 */
package won.owner.model;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import won.owner.model.TokenPurpose;
import won.owner.model.User;

@Entity
@Table(name="verificationtoken")
public class EmailVerificationToken {
    private static final int EXPIRATION = 1440;
    private static final TokenPurpose DEFAULT_PURPOSE = TokenPurpose.INITIAL_EMAIL_VERIFICATION;
    @Id
    @GeneratedValue
    private Long id;
    private String token;
    @OneToOne(targetEntity=User.class, fetch=FetchType.EAGER)
    @JoinColumn(nullable=false, name="user_id")
    private User user;
    @Column(name="purpose")
    @Enumerated(value=EnumType.STRING)
    private TokenPurpose purpose;
    private Date expiryDate;

    public EmailVerificationToken() {
    }

    public EmailVerificationToken(User user, String token, Date expiryDate, TokenPurpose purpose) {
        this.user = user;
        this.token = token;
        this.expiryDate = expiryDate;
        this.purpose = purpose;
    }

    public EmailVerificationToken(User user, String token) {
        this.user = user;
        this.token = token;
        this.expiryDate = this.calculateExpiryDate(1440);
        this.purpose = TokenPurpose.INITIAL_EMAIL_VERIFICATION;
    }

    private Date calculateExpiryDate(int expiryTimeInMinutes) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Timestamp(cal.getTime().getTime()));
        cal.add(12, expiryTimeInMinutes);
        return new Date(cal.getTime().getTime());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public void setPurpose(TokenPurpose purpose) {
        this.purpose = purpose;
    }

    public TokenPurpose getPurpose() {
        return this.purpose;
    }

    public boolean isExpired() {
        return this.isExpired(Calendar.getInstance());
    }

    public boolean isExpired(Calendar cal) {
        return this.getExpiryDate().getTime() - cal.getTime().getTime() <= 0L;
    }
}

