/*
 * Decompiled with CFR 0.152.
 */
package won.owner.messaging;

import java.net.URI;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.cryptography.service.CryptographyService;
import won.cryptography.service.RegistrationClient;
import won.cryptography.service.RegistrationRestClientHttps;
import won.cryptography.service.keystore.KeyStoreService;
import won.cryptography.ssl.AliasFromFingerprintGenerator;
import won.cryptography.ssl.AliasGenerator;
import won.owner.messaging.OwnerProtocolCamelConfiguratorImpl;
import won.protocol.exception.CamelConfigurationFailedException;
import won.protocol.exception.NoSuchConnectionException;
import won.protocol.jms.ActiveMQService;
import won.protocol.jms.CamelConfiguration;
import won.protocol.jms.MessagingService;
import won.protocol.jms.OwnerProtocolCamelConfigurator;
import won.protocol.jms.OwnerProtocolCommunicationService;
import won.protocol.model.Atom;
import won.protocol.model.Connection;
import won.protocol.model.WonNode;
import won.protocol.repository.AtomRepository;
import won.protocol.repository.ConnectionRepository;
import won.protocol.repository.WonNodeRepository;
import won.protocol.util.DataAccessUtils;
import won.protocol.util.LoggingUtils;

public class OwnerProtocolCommunicationServiceImpl
implements OwnerProtocolCommunicationService {
    @Autowired
    private OwnerProtocolCamelConfiguratorImpl ownerProtocolCamelConfigurator;
    private ActiveMQService activeMQService;
    @Autowired
    private AtomRepository atomRepository;
    @Autowired
    private ConnectionRepository connectionRepository;
    @Autowired
    private WonNodeRepository wonNodeRepository;
    @Autowired
    private CryptographyService cryptographyService;
    @Autowired
    private KeyStoreService keyStoreService;
    private AliasGenerator aliasGenerator = new AliasFromFingerprintGenerator();
    private RegistrationClient registrationClient;
    public static final String REMOTE_INCOMING_QUEUE_PREFIX = ":queue:OwnerProtocol.Out.";
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public void setRegistrationClient(RegistrationRestClientHttps registrationClient) {
        this.registrationClient = registrationClient;
    }

    public synchronized boolean isRegisteredWithWonNode(URI wonNodeURI) {
        try {
            String ownerApplicationId = this.calculateOwnerApplicationIdFromOwnerCertificate();
            this.logger.debug("using ownerApplicationId: {}", (Object)ownerApplicationId);
            WonNode wonNode = this.wonNodeRepository.findOneByWonNodeURIAndOwnerApplicationID(wonNodeURI, ownerApplicationId);
            return this.ownerProtocolCamelConfigurator.getCamelContext().getComponent(wonNode.getBrokerComponent()) != null;
        }
        catch (Exception e) {
            this.logger.info("error while checking if we are registered with WoN node " + wonNodeURI, (Throwable)e);
            return false;
        }
    }

    public synchronized void register(URI wonNodeURI, MessagingService messagingService) throws Exception {
        CamelConfiguration camelConfiguration = null;
        this.logger.debug("setting up communication with won node {} ", (Object)wonNodeURI);
        String ownerApplicationId = this.calculateOwnerApplicationIdFromOwnerCertificate();
        this.logger.debug("using ownerApplicationId: {}", (Object)ownerApplicationId);
        WonNode wonNode = this.wonNodeRepository.findOneByWonNodeURIAndOwnerApplicationID(wonNodeURI, ownerApplicationId);
        if (wonNode != null) {
            try {
                this.logger.debug("we're already registered. Connecting with WoN node: " + wonNodeURI);
                this.configureCamelEndpoint(wonNodeURI, ownerApplicationId);
                this.configureRemoteEndpointForOwnerApplication(ownerApplicationId, this.getProtocolCamelConfigurator().getEndpoint(wonNodeURI));
                this.logger.debug("connected with WoN node: " + wonNodeURI);
                return;
            }
            catch (Exception e) {
                LoggingUtils.logMessageAsInfoAndStacktraceAsDebug((Logger)this.logger, (Exception)e, (String)"We thought we were already registerd, but connecting to {} failed With an exception. Trying to re-register. ", (Object[])new Object[]{wonNodeURI});
            }
        }
        this.logger.info("we're not yet registered. Registering with WoN node {} under ownerApplicationId {}", (Object)wonNodeURI, (Object)ownerApplicationId);
        String nodeGeneratedOwnerApplicationId = this.registrationClient.register(wonNodeURI.toString());
        if (!ownerApplicationId.equals(nodeGeneratedOwnerApplicationId)) {
            throw new IllegalStateException("WoN node " + wonNodeURI + " generated an ownerApplicationId that differs from ours. Node generated: " + nodeGeneratedOwnerApplicationId + ", we generated: " + ownerApplicationId);
        }
        this.logger.debug("registered with WoN node: " + wonNodeURI + ",  ownerappID: " + ownerApplicationId);
        camelConfiguration = this.configureCamelEndpoint(wonNodeURI, ownerApplicationId);
        this.storeWonNode(ownerApplicationId, camelConfiguration, wonNodeURI);
        this.configureRemoteEndpointForOwnerApplication(ownerApplicationId, this.getProtocolCamelConfigurator().getEndpoint(wonNodeURI));
        this.logger.info("connected with WoN node: : " + wonNodeURI);
    }

    private String calculateOwnerApplicationIdFromOwnerCertificate() throws CertificateException {
        Certificate cert = this.keyStoreService.getCertificate(this.cryptographyService.getDefaultPrivateKeyAlias());
        return this.aliasGenerator.generateAlias((X509Certificate)cert);
    }

    private void configureRemoteEndpointForOwnerApplication(String ownerApplicationID, String remoteEndpoint) throws CamelConfigurationFailedException, ExecutionException, InterruptedException {
        this.getProtocolCamelConfigurator().addRemoteQueueListener(REMOTE_INCOMING_QUEUE_PREFIX + ownerApplicationID, URI.create(remoteEndpoint));
    }

    public WonNode storeWonNode(String ownerApplicationId, CamelConfiguration camelConfiguration, URI wonNodeURI) throws NoSuchConnectionException {
        WonNode wonNode = DataAccessUtils.loadWonNode((WonNodeRepository)this.wonNodeRepository, (URI)wonNodeURI);
        if (wonNode == null) {
            wonNode = new WonNode();
        }
        wonNode.setOwnerApplicationID(ownerApplicationId);
        wonNode.setOwnerProtocolEndpoint(camelConfiguration.getEndpoint());
        wonNode.setWonNodeURI(wonNodeURI);
        wonNode.setBrokerURI(this.getBrokerUri(wonNodeURI));
        wonNode.setBrokerComponent(camelConfiguration.getBrokerComponentName());
        wonNode.setStartingComponent(this.getProtocolCamelConfigurator().getStartingEndpoint(wonNodeURI));
        this.wonNodeRepository.save((Object)wonNode);
        this.logger.debug("setting starting component {}", (Object)wonNode.getStartingComponent());
        return wonNode;
    }

    public final synchronized CamelConfiguration configureCamelEndpoint(URI wonNodeUri, String ownerId) throws Exception {
        CamelConfiguration camelConfiguration = new CamelConfiguration();
        URI brokerURI = this.activeMQService.getBrokerEndpoint(wonNodeUri);
        List wonNodeList = this.wonNodeRepository.findByWonNodeURI(wonNodeUri);
        this.logger.debug("configuring camel endpoint");
        if (this.ownerProtocolCamelConfigurator.getBrokerComponentName(brokerURI) != null && this.ownerProtocolCamelConfigurator.getEndpoint(wonNodeUri) != null) {
            this.logger.debug("wonNode known");
            WonNode wonNode = (WonNode)wonNodeList.get(0);
            camelConfiguration.setEndpoint(wonNode.getOwnerProtocolEndpoint());
            if (this.ownerProtocolCamelConfigurator.getCamelContext().getComponent(((WonNode)wonNodeList.get(0)).getBrokerComponent()) == null) {
                String ownerProtocolQueueName = this.activeMQService.getProtocolQueueNameWithResource(wonNodeUri);
                String endpoint = this.ownerProtocolCamelConfigurator.configureCamelEndpointForNodeURI(wonNodeUri, brokerURI, ownerProtocolQueueName);
                camelConfiguration.setBrokerComponentName(this.ownerProtocolCamelConfigurator.getBrokerComponentName(brokerURI));
                this.ownerProtocolCamelConfigurator.getCamelContext().getComponent(camelConfiguration.getBrokerComponentName()).createEndpoint(camelConfiguration.getEndpoint());
                if (this.ownerProtocolCamelConfigurator.getCamelContext().getRoute(wonNode.getStartingComponent()) == null) {
                    this.ownerProtocolCamelConfigurator.addRouteForEndpoint(null, wonNode.getWonNodeURI());
                }
            }
        } else {
            this.logger.debug("wonNode unknown");
            String ownerProtocolQueueName = this.activeMQService.getProtocolQueueNameWithResource(wonNodeUri);
            String endpoint = this.ownerProtocolCamelConfigurator.configureCamelEndpointForNodeURI(wonNodeUri, brokerURI, ownerProtocolQueueName);
            camelConfiguration.setEndpoint(endpoint);
            camelConfiguration.setBrokerComponentName(this.ownerProtocolCamelConfigurator.getBrokerComponentName(brokerURI));
            this.ownerProtocolCamelConfigurator.addRouteForEndpoint(null, wonNodeUri);
        }
        return camelConfiguration;
    }

    public synchronized URI getWonNodeUriWithConnectionUri(URI connectionUri) throws NoSuchConnectionException {
        Connection con = DataAccessUtils.loadConnection((ConnectionRepository)this.connectionRepository, (URI)connectionUri);
        URI atomURI = con.getAtomURI();
        Atom atom = (Atom)this.atomRepository.findByAtomURI(atomURI).get(0);
        return atom.getWonNodeURI();
    }

    public synchronized URI getWonNodeUriWithAtomUri(URI atomUri) throws NoSuchConnectionException {
        Atom atom = (Atom)this.atomRepository.findByAtomURI(atomUri).get(0);
        return atom.getWonNodeURI();
    }

    public URI getBrokerUri(URI resourceUri) throws NoSuchConnectionException {
        return this.activeMQService.getBrokerEndpoint(resourceUri);
    }

    public ActiveMQService getActiveMQService() {
        return this.activeMQService;
    }

    public void setActiveMQService(ActiveMQService activeMQService) {
        this.activeMQService = activeMQService;
    }

    public OwnerProtocolCamelConfigurator getProtocolCamelConfigurator() {
        return this.ownerProtocolCamelConfigurator;
    }

    public void setCryptographyService(CryptographyService cryptographyService) {
        this.cryptographyService = cryptographyService;
    }
}

