/*
 * Decompiled with CFR 0.152.
 */
package won.owner.messaging;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.RoutesBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.cryptography.ssl.MessagingContext;
import won.owner.camel.routes.OwnerApplicationListenerRouteBuilder;
import won.owner.camel.routes.OwnerProtocolDynamicRoutes;
import won.protocol.exception.CamelConfigurationFailedException;
import won.protocol.jms.BrokerComponentFactory;
import won.protocol.jms.OwnerProtocolCamelConfigurator;
import won.protocol.model.MessagingType;
import won.protocol.repository.AtomRepository;
import won.protocol.repository.ConnectionRepository;

public class OwnerProtocolCamelConfiguratorImpl
implements OwnerProtocolCamelConfigurator {
    private CamelContext camelContext;
    private MessagingContext messagingContext;
    @Autowired
    private AtomRepository atomRepository;
    @Autowired
    private ConnectionRepository connectionRepository;
    @Autowired
    private BrokerComponentFactory brokerComponentFactory;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private BiMap<URI, String> endpointMap = HashBiMap.create();
    private Map<URI, String> startingComponentMap = new HashMap<URI, String>();
    private BiMap<URI, String> brokerComponentMap = HashBiMap.create();
    private String startingComponent;
    private String componentName;
    private String defaultNodeURI;

    protected OwnerProtocolCamelConfiguratorImpl() {
    }

    public final synchronized String configureCamelEndpointForNodeURI(URI wonNodeURI, URI brokerURI, String ownerProtocolQueueName) throws CamelConfigurationFailedException {
        String brokerComponentName = this.setupBrokerComponentName(brokerURI);
        this.addCamelComponentForWonNodeBroker(brokerURI, brokerComponentName);
        String endpoint = brokerComponentName + ":queue:" + ownerProtocolQueueName;
        this.endpointMap.put((Object)wonNodeURI, (Object)endpoint);
        ArrayList<String> endpointList = new ArrayList<String>();
        endpointList.add(endpoint);
        logger.info("endpoint of wonNodeURI {} is {}", (Object)wonNodeURI, this.endpointMap.get((Object)wonNodeURI));
        return (String)endpointList.get(0);
    }

    public synchronized void addRemoteQueueListener(String endpoint, URI remoteEndpoint) throws CamelConfigurationFailedException {
        endpoint = remoteEndpoint.getScheme() + endpoint;
        if (this.camelContext.hasEndpoint(endpoint) != null) {
            logger.debug("route for listening to remote queue {} already configured", (Object)remoteEndpoint);
            return;
        }
        logger.debug("Adding route for listening to remote queue {} ", (Object)endpoint);
        OwnerApplicationListenerRouteBuilder ownerApplicationListenerRouteBuilder = new OwnerApplicationListenerRouteBuilder(this.camelContext, endpoint, remoteEndpoint);
        try {
            this.camelContext.addRoutes((RoutesBuilder)ownerApplicationListenerRouteBuilder);
        }
        catch (Exception e) {
            logger.debug("adding route to camel context failed", (Throwable)e);
            throw new CamelConfigurationFailedException("adding route to camel context failed", (Throwable)e);
        }
    }

    private List<String> adjustSchemeToRemoteEndpoint(List<String> endpoints, URI remoteEndpoint) {
        String remoteScheme = remoteEndpoint.getScheme();
        ArrayList<String> customSchemeEndpoints = new ArrayList<String>(endpoints.size());
        for (String ep : endpoints) {
            String epScheme = URI.create(ep).getScheme();
            ep = ep.replace(epScheme, remoteScheme);
            customSchemeEndpoints.add(ep);
        }
        return customSchemeEndpoints;
    }

    public synchronized void addCamelComponentForWonNodeBroker(URI brokerURI, String brokerComponentName) {
        if (this.camelContext.getComponent(brokerComponentName, false) == null) {
            ActiveMQComponent activeMQComponent = (ActiveMQComponent)this.brokerComponentFactory.getBrokerComponent(brokerURI, MessagingType.Queue, this.messagingContext);
            this.camelContext.addComponent(brokerComponentName, (Component)activeMQComponent);
            logger.info("adding component with component name {}", (Object)brokerComponentName);
            if (!this.brokerComponentMap.containsKey((Object)brokerURI)) {
                this.brokerComponentMap.put((Object)brokerURI, (Object)brokerComponentName);
            }
        }
    }

    public void addRouteForEndpoint(String startingEndpoint, URI wonNodeURI) throws CamelConfigurationFailedException {
        this.addRouteForWoNNode(wonNodeURI);
    }

    public synchronized void addRouteForWoNNode(URI wonNodeURI) throws CamelConfigurationFailedException {
        String tempStartingComponentName = this.startingComponent;
        tempStartingComponentName = tempStartingComponentName + ((String)this.endpointMap.get((Object)wonNodeURI)).replaceAll(":", "_");
        this.setStartingEndpoint(wonNodeURI, tempStartingComponentName);
        if (this.camelContext.getComponent(tempStartingComponentName) == null || this.camelContext.getRoute((String)this.endpointMap.get((Object)wonNodeURI)) == null) {
            RoutesBuilder ownerProtocolRouteBuilder = this.createRoutesBuilder(tempStartingComponentName, wonNodeURI);
            try {
                this.camelContext.addRoutes(ownerProtocolRouteBuilder);
            }
            catch (Exception e) {
                throw new CamelConfigurationFailedException("adding route to camel context failed", (Throwable)e);
            }
        }
    }

    protected RoutesBuilder createRoutesBuilder(String startingComponent, URI brokerUri) {
        return new OwnerProtocolDynamicRoutes(this.camelContext, startingComponent);
    }

    public String getStartingEndpoint(URI wonNodeURI) {
        return this.startingComponentMap.get(wonNodeURI);
    }

    public void setStartingEndpoint(URI wonNodeURI, String startingEndpoint) {
        this.startingComponentMap.put(wonNodeURI, startingEndpoint);
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setMessagingContext(MessagingContext messagingContext) {
        this.messagingContext = messagingContext;
    }

    public String getEndpoint(URI wonNodeUri) {
        return (String)this.endpointMap.get((Object)wonNodeUri);
    }

    public String setupBrokerComponentName(URI brokerUri) {
        return this.componentName + brokerUri.toString().replaceAll("[/:]", "");
    }

    public void setStartingComponent(String startingComponent) {
        this.startingComponent = startingComponent;
    }

    public String getBrokerComponentName(URI brokerUri) {
        return (String)this.brokerComponentMap.get((Object)brokerUri);
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public void setDefaultNodeURI(String defaultNodeURI) {
        this.defaultNodeURI = defaultNodeURI;
    }
}

