/*
 * Decompiled with CFR 0.152.
 */
package won.owner.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import won.owner.model.KeystoreHolder;
import won.owner.model.KeystorePasswordHolder;
import won.owner.model.User;
import won.owner.repository.UserRepository;
import won.owner.service.impl.KeystorePasswordUtils;
import won.owner.service.impl.UserAlreadyExistsException;
import won.owner.service.impl.UserNotFoundException;

@Service
public class UserService {
    @Autowired
    private UserRepository userRepository;

    public void transferUser(String newEmail, String newPassword, String privateUsername, String privatePassword) throws UserAlreadyExistsException, UserNotFoundException {
        this.transferUser(newEmail, newPassword, privateUsername, privatePassword, null);
    }

    public void transferUser(String newEmail, String newPassword, String privateUsername, String privatePassword, String role) throws UserAlreadyExistsException, UserNotFoundException {
        User user = this.getByUsername(newEmail);
        if (user != null) {
            throw new UserAlreadyExistsException();
        }
        try {
            BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
            User privateUser = this.getByUsernameWithKeystorePassword(privateUsername);
            if (privateUser == null) {
                throw new UserNotFoundException();
            }
            privateUser.setUsername(newEmail);
            privateUser.setPassword(passwordEncoder.encode((CharSequence)newPassword));
            privateUser.setEmail(newEmail);
            if (role != null) {
                privateUser.setRole(role);
            }
            KeystorePasswordHolder privateKeystorePassword = privateUser.getKeystorePasswordHolder();
            String keystorePassword = privateKeystorePassword.getPassword(privatePassword);
            KeystorePasswordHolder newKeystorePassword = new KeystorePasswordHolder();
            newKeystorePassword.setPassword(keystorePassword, newPassword);
            privateUser.setKeystorePasswordHolder(newKeystorePassword);
            this.save(privateUser);
        }
        catch (DataIntegrityViolationException e) {
            throw new UserAlreadyExistsException();
        }
    }

    public void registerUser(String email, String password, String role) throws UserAlreadyExistsException {
        User user = this.getByUsername(email);
        if (user != null) {
            throw new UserAlreadyExistsException();
        }
        try {
            BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
            user = new User(email, passwordEncoder.encode((CharSequence)password), role);
            user.setEmail(email);
            KeystorePasswordHolder keystorePassword = new KeystorePasswordHolder();
            keystorePassword.setPassword(KeystorePasswordUtils.generatePassword(32), password);
            KeystoreHolder keystoreHolder = new KeystoreHolder();
            try {
                keystoreHolder.getKeystore(keystorePassword.getPassword(password));
            }
            catch (Exception e) {
                throw new IllegalStateException("could not create keystore for user " + email);
            }
            user.setKeystorePasswordHolder(keystorePassword);
            user.setKeystoreHolder(keystoreHolder);
            this.save(user);
        }
        catch (DataIntegrityViolationException e) {
            throw new UserAlreadyExistsException();
        }
    }

    public User getByUsername(String username) {
        return this.userRepository.findByUsername(username);
    }

    public User getByUsernameWithKeystorePassword(String username) {
        return this.userRepository.findByUsernameWithKeystorePassword(username);
    }

    public void save(User user) {
        this.userRepository.save(user);
    }
}

