/*
 * Decompiled with CFR 0.152.
 */
package won.owner.service.impl;

import java.security.KeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import won.cryptography.service.keystore.AbstractKeyStoreService;
import won.owner.model.User;
import won.owner.repository.KeystoreHolderRepository;
import won.owner.service.impl.KeystoreEnabledUserDetails;
import won.protocol.util.AuthenticationThreadLocal;

@Component
public class PerUserKeystoreService
extends AbstractKeyStoreService {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private KeystoreHolderRepository keystoreHolderRepository;

    private String getUsername() {
        return SecurityContextHolder.getContext().getAuthentication().getName();
    }

    private Authentication getAuthentication() {
        if (AuthenticationThreadLocal.hasValue()) {
            return (Authentication)AuthenticationThreadLocal.getAuthentication();
        }
        return SecurityContextHolder.getContext().getAuthentication();
    }

    private KeystoreEnabledUserDetails getKeystoreUserDetails() {
        return (KeystoreEnabledUserDetails)this.getAuthentication().getPrincipal();
    }

    private User getUser() {
        return ((KeystoreEnabledUserDetails)this.getAuthentication().getPrincipal()).getUser();
    }

    public String getPassword() {
        return this.getKeystoreUserDetails().getKeystorePassword();
    }

    public KeyStore getUnderlyingKeyStore() {
        return this.getKeystoreUserDetails().getKeyStore();
    }

    protected void persistStore() throws Exception {
        KeystoreEnabledUserDetails keystoreUserDetails = this.getKeystoreUserDetails();
        User user = this.getUser();
        user.getKeystoreHolder().setKeystore(keystoreUserDetails.getKeyStore(), keystoreUserDetails.getKeystorePassword());
        this.keystoreHolderRepository.save(user.getKeystoreHolder());
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setKeystoreHolderRepository(KeystoreHolderRepository keystoreHolderRepository) {
        this.keystoreHolderRepository = keystoreHolderRepository;
    }
}

