/*
 * Decompiled with CFR 0.152.
 */
package won.owner.service.impl;

import java.io.Serializable;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.rememberme.CookieTheftException;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.security.web.authentication.rememberme.PersistentTokenBasedRememberMeServices;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import won.owner.model.KeystoreHolder;
import won.owner.model.KeystorePasswordHolder;
import won.owner.model.PersistentLogin;
import won.owner.model.User;
import won.owner.repository.KeystorePasswordRepository;
import won.owner.repository.PersistentLoginRepository;
import won.owner.service.impl.KeystoreEnabledUserDetails;
import won.owner.service.impl.KeystorePasswordUtils;

public class KeystoreEnabledPersistentRememberMeServices
extends PersistentTokenBasedRememberMeServices {
    private static final String UNLOCK_COOKIE_NAME = "won.unlock";
    @Autowired
    private PersistentLoginRepository persistentLoginRepository;
    @Autowired
    private KeystorePasswordRepository keystorePasswordRepository;
    @Autowired
    private PlatformTransactionManager platformTransactionManager;

    public KeystoreEnabledPersistentRememberMeServices(String key, UserDetailsService userDetailsService, PersistentTokenRepository tokenRepository) {
        super(key, userDetailsService, tokenRepository);
    }

    @Transactional
    protected UserDetails processAutoLoginCookie(String[] cookieTokens, final HttpServletRequest request, final HttpServletResponse response) {
        if (cookieTokens.length != 2) {
            throw new InvalidCookieException("Cookie token did not contain 2 tokens, but contained '" + Arrays.asList(cookieTokens) + "'");
        }
        final String presentedSeries = cookieTokens[0];
        final String presentedToken = cookieTokens[1];
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.platformTransactionManager);
        return (UserDetails)transactionTemplate.execute((TransactionCallback)new TransactionCallback<UserDetails>(){

            public UserDetails doInTransaction(TransactionStatus status) {
                KeyStore keystore;
                String unlockKey;
                PersistentLogin persistentLogin = (PersistentLogin)KeystoreEnabledPersistentRememberMeServices.this.persistentLoginRepository.findOne((Serializable)((Object)presentedSeries));
                if (persistentLogin == null) {
                    throw new RememberMeAuthenticationException("No persistent token found for series id: " + presentedSeries);
                }
                if (!presentedToken.equals(persistentLogin.getToken())) {
                    KeystoreEnabledPersistentRememberMeServices.this.persistentLoginRepository.deleteByUsername(persistentLogin.getUsername());
                    throw new CookieTheftException(KeystoreEnabledPersistentRememberMeServices.this.messages.getMessage("PersistentTokenBasedRememberMeServices.cookieStolen", "Invalid remember-me token (Series/token) mismatch. Implies previous cookie theft attack."));
                }
                if (persistentLogin.getLastUsed().getTime() + (long)KeystoreEnabledPersistentRememberMeServices.this.getTokenValiditySeconds() * 1000L < System.currentTimeMillis()) {
                    throw new RememberMeAuthenticationException("Remember-me login has expired");
                }
                if (KeystoreEnabledPersistentRememberMeServices.this.logger.isDebugEnabled()) {
                    KeystoreEnabledPersistentRememberMeServices.this.logger.debug((Object)("Refreshing persistent login token for user '" + persistentLogin.getUsername() + "', series '" + persistentLogin.getSeries() + "'"));
                }
                if ((unlockKey = KeystoreEnabledPersistentRememberMeServices.this.extractUnlockCookie(request)) == null) {
                    throw new CookieTheftException("The rememberMe cookie was ok but no unlock cookie was found.");
                }
                KeystorePasswordHolder keystorePasswordHolder = persistentLogin.getKeystorePasswordHolder();
                String keystorePassword = keystorePasswordHolder.getPassword(unlockKey);
                persistentLogin.setLastUsed(new Date());
                persistentLogin.setToken(KeystoreEnabledPersistentRememberMeServices.this.generateTokenData());
                persistentLogin.setKeystorePasswordHolder(keystorePasswordHolder);
                String newUnlockKey = KeystorePasswordUtils.generatePassword(256);
                keystorePasswordHolder.setPassword(keystorePassword, newUnlockKey);
                try {
                    KeystoreEnabledPersistentRememberMeServices.this.persistentLoginRepository.save(persistentLogin);
                    KeystoreEnabledPersistentRememberMeServices.this.addCookies(persistentLogin, newUnlockKey, request, response);
                }
                catch (Exception e) {
                    KeystoreEnabledPersistentRememberMeServices.this.logger.error((Object)"Failed to update token: ", (Throwable)e);
                    throw new RememberMeAuthenticationException("Autologin failed due to data access problem");
                }
                User userDetails = (User)KeystoreEnabledPersistentRememberMeServices.this.getUserDetailsService().loadUserByUsername(persistentLogin.getUsername());
                KeystoreHolder keystoreHolder = userDetails.getKeystoreHolder();
                try {
                    keystore = keystoreHolder.getKeystore(keystorePassword);
                }
                catch (Exception e) {
                    KeystoreEnabledPersistentRememberMeServices.this.logger.error((Object)"Failed to load keystore: ", (Throwable)e);
                    throw new RememberMeAuthenticationException("Autologin failed due to data access problem");
                }
                KeystoreEnabledUserDetails keystoreEnabledUserDetails = new KeystoreEnabledUserDetails(userDetails, keystore, keystorePassword);
                keystore = null;
                keystorePassword = null;
                return keystoreEnabledUserDetails;
            }
        });
    }

    @Transactional
    protected void onLoginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        String username = successfulAuthentication.getName();
        KeystoreEnabledUserDetails keystoreEnabledUserDetails = (KeystoreEnabledUserDetails)successfulAuthentication.getPrincipal();
        this.logger.debug((Object)("Creating new persistent login for user " + username));
        PersistentLogin persistentLogin = new PersistentLogin();
        persistentLogin.setUsername(username);
        persistentLogin.setSeries(this.generateSeriesData());
        persistentLogin.setToken(this.generateTokenData());
        persistentLogin.setLastUsed(new Date());
        String newUnlockKey = KeystorePasswordUtils.generatePassword(32);
        KeystorePasswordHolder keystorePasswordHolder = new KeystorePasswordHolder();
        keystorePasswordHolder.setPassword(keystoreEnabledUserDetails.getKeystorePassword(), newUnlockKey);
        persistentLogin.setKeystorePasswordHolder(keystorePasswordHolder);
        try {
            this.persistentLoginRepository.save(persistentLogin);
            this.addCookies(persistentLogin, newUnlockKey, request, response);
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to update token: ", (Throwable)e);
            throw new RememberMeAuthenticationException("Autologin failed due to data access problem");
        }
    }

    private void addCookies(PersistentLogin persistentLogin, String key, HttpServletRequest request, HttpServletResponse response) {
        int validity = this.getTokenValiditySeconds();
        this.setCookie(new String[]{persistentLogin.getSeries(), persistentLogin.getToken()}, validity, request, response);
        this.setUnlockCookie(key, validity, request, response);
    }

    private String getCookiePath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        return contextPath.length() > 0 ? contextPath : "/";
    }

    protected void setUnlockCookie(String value, int maxAge, HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = new Cookie(UNLOCK_COOKIE_NAME, value);
        cookie.setMaxAge(maxAge);
        cookie.setPath(this.getCookiePath(request));
        if (maxAge < 1) {
            cookie.setVersion(1);
        }
        cookie.setSecure(request.isSecure());
        response.addCookie(cookie);
    }

    protected String extractUnlockCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!UNLOCK_COOKIE_NAME.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }
}

