/*
 * Decompiled with CFR 0.152.
 */
package won.owner.protocol.message.base;

import org.apache.jena.query.Dataset;
import org.apache.jena.riot.Lang;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import won.owner.protocol.message.OwnerCallback;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageType;
import won.protocol.message.processor.WonMessageProcessor;
import won.protocol.message.processor.exception.WonMessageProcessingException;
import won.protocol.model.Connection;
import won.protocol.model.Match;
import won.protocol.util.RdfUtils;

public abstract class OwnerCallbackAdapter
implements WonMessageProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private OwnerCallback adaptee;

    protected OwnerCallbackAdapter() {
    }

    public OwnerCallbackAdapter(OwnerCallback adaptee) {
        this.adaptee = adaptee;
    }

    protected abstract Connection makeConnection(WonMessage var1);

    protected abstract Match makeMatch(WonMessage var1);

    public WonMessage process(WonMessage message) throws WonMessageProcessingException {
        assert (this.adaptee != null) : "adaptee is not set";
        this.logger.debug("processing message {} and calling appropriate method on adaptee", (Object)message.getMessageURI());
        WonMessageType messageType = message.getMessageType();
        switch (messageType) {
            case HINT_MESSAGE: {
                this.adaptee.onHintFromMatcher(this.makeMatch(message), message);
                break;
            }
            case CONNECT: {
                this.adaptee.onConnectFromOtherNeed(this.makeConnection(message), message);
                break;
            }
            case OPEN: {
                this.adaptee.onOpenFromOtherNeed(this.makeConnection(message), message);
                break;
            }
            case CONNECTION_MESSAGE: {
                this.adaptee.onMessageFromOtherNeed(this.makeConnection(message), message);
                break;
            }
            case CLOSE: {
                this.adaptee.onCloseFromOtherNeed(this.makeConnection(message), message);
                break;
            }
            case SUCCESS_RESPONSE: {
                this.adaptee.onSuccessResponse(message.getIsResponseToMessageURI(), message);
                break;
            }
            case FAILURE_RESPONSE: {
                this.adaptee.onFailureResponse(message.getIsResponseToMessageURI(), message);
                break;
            }
            default: {
                this.logger.info("could not find callback method for wonMessage of type {}", (Object)messageType);
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug("message: {}", (Object)RdfUtils.writeDatasetToString((Dataset)message.getCompleteDataset(), (Lang)Lang.TRIG));
            }
        }
        return message;
    }

    @Autowired(required=false)
    @Qualifier(value="default")
    public void setAdaptee(OwnerCallback adaptee) {
        this.adaptee = adaptee;
    }
}

