/*
 * Decompiled with CFR 0.152.
 */
package won.owner.protocol.message.base;

import java.net.URI;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.tdb.TDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.owner.protocol.message.OwnerCallback;
import won.owner.protocol.message.base.OwnerCallbackAdapter;
import won.protocol.exception.DataIntegrityException;
import won.protocol.message.WonMessage;
import won.protocol.message.processor.exception.WonMessageProcessingException;
import won.protocol.model.Connection;
import won.protocol.model.ConnectionState;
import won.protocol.model.Match;
import won.protocol.util.RdfUtils;
import won.protocol.util.WonRdfUtils;
import won.protocol.util.linkeddata.LinkedDataSource;

public class DatasetBackedOwnerCallbackAdapter
extends OwnerCallbackAdapter {
    private static final String QUERY_CONNECTION = "SELECT ?con ?need ?state ?remoteCon ?remoteNeed ?type where {   ?con won:belongsToNeed ?need;      won:isInState ?state;      won:hasFacet ?type;      won:hasRemoteNeed ?remoteNeed.  OPTIONAL {     ?con won:hasRemoteConnection ?remoteCon  } } ";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Dataset dataset;
    @Autowired
    private LinkedDataSource linkedDataSource;

    public DatasetBackedOwnerCallbackAdapter(OwnerCallback adaptee) {
        super(adaptee);
    }

    @Override
    public WonMessage process(WonMessage message) throws WonMessageProcessingException {
        RdfUtils.addDatasetToDataset((Dataset)this.dataset, (Dataset)message.getCompleteDataset());
        return super.process(message);
    }

    public void setLinkedDataSource(LinkedDataSource linkedDataSource) {
        this.linkedDataSource = linkedDataSource;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Connection makeConnection(WonMessage wonMessage) {
        URI connUri = wonMessage.getReceiverURI();
        ParameterizedSparqlString pss = new ParameterizedSparqlString();
        pss.setNsPrefix("won", "http://purl.org/webofneeds/model#");
        pss.setCommandText(QUERY_CONNECTION);
        pss.setIri("con", connUri.toString());
        Query query = pss.asQuery();
        QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Dataset)this.dataset);
        qExec.getContext().set(TDB.symUnionDefaultGraph, true);
        try {
            Connection con = null;
            ResultSet results = qExec.execSelect();
            if (results.hasNext()) {
                QuerySolution soln = results.next();
                if (results.hasNext()) {
                    throw new DataIntegrityException("Query must not yield multiple solutions");
                }
                con = new Connection();
                con.setConnectionURI(this.getURIFromSolution(soln, "con"));
                con.setTypeURI(this.getURIFromSolution(soln, "type"));
                con.setNeedURI(this.getURIFromSolution(soln, "need"));
                con.setState(ConnectionState.fromURI((URI)this.getURIFromSolution(soln, "state")));
                con.setRemoteNeedURI(this.getURIFromSolution(soln, "remoteNeed"));
                con.setRemoteConnectionURI(this.getURIFromSolution(soln, "remoteCon"));
            }
            Connection connection = con;
            return connection;
        }
        finally {
            if (!qExec.isClosed()) {
                qExec.close();
            }
        }
    }

    private URI getURIFromSolution(QuerySolution soln, String var) {
        return URI.create(soln.getResource(var).getURI().toString());
    }

    @Override
    protected Match makeMatch(WonMessage wonMessage) {
        return WonRdfUtils.MessageUtils.toMatch((WonMessage)wonMessage);
    }
}

