/*
 * Decompiled with CFR 0.152.
 */
package won.owner.protocol.message;

import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.protocol.message.WonMessage;
import won.protocol.message.processor.WonMessageProcessor;
import won.protocol.message.processor.exception.WonMessageProcessingException;
import won.protocol.util.linkeddata.CachingLinkedDataSource;
import won.protocol.util.linkeddata.LinkedDataSource;

public class LinkedDataCacheUpdater
implements WonMessageProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private LinkedDataSource linkedDataSourceOnBehalfOfNeed;

    public WonMessage process(WonMessage message) throws WonMessageProcessingException {
        if (this.linkedDataSourceOnBehalfOfNeed != null && this.linkedDataSourceOnBehalfOfNeed instanceof CachingLinkedDataSource) {
            this.logger.debug("putting message {} into cache", (Object)message.getMessageURI());
            URI requester = message.getReceiverNeedURI();
            ((CachingLinkedDataSource)this.linkedDataSourceOnBehalfOfNeed).addToCache(message.getCompleteDataset(), message.getMessageURI(), requester);
        }
        return message;
    }

    public void setLinkedDataSourceOnBehalfOfNeed(LinkedDataSource linkedDataSourceOnBehalfOfNeed) {
        this.linkedDataSourceOnBehalfOfNeed = linkedDataSourceOnBehalfOfNeed;
    }
}

