/*
 * Decompiled with CFR 0.152.
 */
package won.owner.protocol.message;

import java.net.URI;
import org.apache.jena.query.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageType;
import won.protocol.message.processor.WonMessageProcessor;
import won.protocol.message.processor.exception.WonMessageProcessingException;
import won.protocol.util.NeedModelWrapper;
import won.protocol.util.linkeddata.CachingLinkedDataSource;
import won.protocol.util.linkeddata.LinkedDataSource;
import won.protocol.util.linkeddata.WonLinkedDataUtils;

public class LinkedDataCacheInvalidator
implements WonMessageProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private CachingLinkedDataSource linkedDataSource;
    private CachingLinkedDataSource linkedDataSourceOnBehalfOfNeed;

    public void setLinkedDataSource(CachingLinkedDataSource linkedDataSource) {
        this.linkedDataSource = linkedDataSource;
    }

    public void setLinkedDataSourceOnBehalfOfNeed(CachingLinkedDataSource linkedDataSourceOnBehalfOfNeed) {
        this.linkedDataSourceOnBehalfOfNeed = linkedDataSourceOnBehalfOfNeed;
    }

    public WonMessage process(WonMessage message) throws WonMessageProcessingException {
        WonMessageType type = message.getMessageType();
        if (type == WonMessageType.SUCCESS_RESPONSE) {
            type = message.getIsResponseToMessageType();
        }
        URI webId = message.getReceiverNeedURI();
        if (message.getReceiverURI() != null) {
            this.logger.debug("invalidating events list for need " + message.getReceiverNeedURI() + " for connection " + message.getReceiverURI());
            URI eventContainerUri = WonLinkedDataUtils.getEventContainerURIforConnectionURI((URI)message.getReceiverURI(), (LinkedDataSource)this.linkedDataSource);
            this.invalidate(eventContainerUri, webId);
            if (type.causesConnectionStateChange()) {
                this.invalidate(message.getReceiverURI(), webId);
            }
        }
        if (type.causesNewConnection()) {
            this.logger.debug("invalidating connections list for need " + message.getReceiverNeedURI());
            Dataset need = this.linkedDataSource.getDataForResource(message.getReceiverNeedURI());
            NeedModelWrapper wrapper = new NeedModelWrapper(need);
            URI connectionsListUri = URI.create(wrapper.getConnectionContainerUri());
            this.invalidate(connectionsListUri, webId);
        }
        if (type.causesNeedStateChange()) {
            this.invalidate(message.getReceiverNeedURI(), webId);
        }
        return message;
    }

    private void invalidate(URI uri, URI webId) {
        if (uri == null) {
            return;
        }
        this.linkedDataSource.invalidate(uri);
        this.linkedDataSource.invalidate(uri, webId);
        if (this.linkedDataSourceOnBehalfOfNeed != this.linkedDataSource) {
            this.linkedDataSourceOnBehalfOfNeed.invalidate(uri);
            this.linkedDataSourceOnBehalfOfNeed.invalidate(uri, webId);
        }
    }
}

