/*
 * Decompiled with CFR 0.152.
 */
package won.owner.model;

import java.net.URI;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import won.protocol.model.NeedState;
import won.protocol.model.URIConverter;

@Entity
public class UserNeed {
    @Id
    @GeneratedValue
    @Column(name="id")
    private Long id;
    @Column(name="uri", unique=true)
    @Convert(converter=URIConverter.class)
    private URI uri;
    @Column(name="matches")
    private boolean matches;
    @Column(name="requests")
    private boolean requests = true;
    @Column(name="conversations")
    private boolean conversations = true;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="creationDate", nullable=false)
    private Date creationDate;
    @Enumerated(value=EnumType.STRING)
    @Column(name="state")
    private NeedState state;

    public UserNeed() {
    }

    @PrePersist
    protected void onCreate() {
        this.creationDate = new Date();
        this.state = NeedState.ACTIVE;
    }

    public UserNeed(URI uri) {
        this.uri = uri;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public boolean isMatches() {
        return this.matches;
    }

    public void setMatches(boolean matches) {
        this.matches = matches;
    }

    public boolean isRequests() {
        return this.requests;
    }

    public void setRequests(boolean requests) {
        this.requests = requests;
    }

    public boolean isConversations() {
        return this.conversations;
    }

    public void setConversations(boolean conversations) {
        this.conversations = conversations;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public NeedState getState() {
        return this.state;
    }

    public void setState(NeedState state) {
        this.state = state;
    }
}

