/*
 * Decompiled with CFR 0.152.
 */
package won.owner.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.springframework.data.domain.Persistable;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import won.owner.model.KeystoreHolder;
import won.owner.model.KeystorePasswordHolder;
import won.owner.model.UserNeed;

@Entity
@Table(name="wonuser", uniqueConstraints={@UniqueConstraint(columnNames={"username"})})
@JsonIgnoreProperties(ignoreUnknown=true)
public class User
implements UserDetails,
Persistable<Long> {
    @Id
    @GeneratedValue
    @Column(name="id")
    private Long id;
    @Column(name="username")
    private String username;
    @Column(name="password")
    private String password;
    @OneToMany(fetch=FetchType.EAGER)
    @OrderBy(value="creationDate desc")
    @JoinTable(name="wonuser_userneed", joinColumns={@JoinColumn(name="wonuser_id")})
    private List<UserNeed> userNeeds;
    @Column(name="role")
    private String role;
    @Column(name="email")
    private String email;
    @JoinColumn(name="keystore_id")
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, optional=false)
    private KeystoreHolder keystoreHolder;
    @JoinColumn(name="keystore_password_id")
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, optional=false)
    private KeystorePasswordHolder keystorePasswordHolder;
    @ElementCollection(fetch=FetchType.EAGER)
    private Set<URI> draftURIs;
    @Transient
    private Collection<SimpleGrantedAuthority> authorities;

    public User() {
    }

    public User(String username, String password) {
        this.username = username;
        this.password = password;
        this.role = "ROLE_ACCOUNT";
        this.email = this.username;
    }

    public User(String username, String password, String role) {
        this.username = username;
        this.password = password;
        this.role = role == null ? "ROLE_ACCOUNT" : role;
    }

    public boolean isNew() {
        return this.id == null;
    }

    public String toString() {
        return "User{id=" + this.id + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", role='" + this.role + '\'' + '}';
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        this.authorities = new ArrayList<SimpleGrantedAuthority>(1);
        this.authorities.add(new SimpleGrantedAuthority(this.role));
        return this.authorities;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public KeystoreHolder getKeystoreHolder() {
        return this.keystoreHolder;
    }

    public void setKeystoreHolder(KeystoreHolder keystoreHolder) {
        this.keystoreHolder = keystoreHolder;
    }

    public void setKeystorePasswordHolder(KeystorePasswordHolder keystorePassword) {
        this.keystorePasswordHolder = keystorePassword;
    }

    public KeystorePasswordHolder getKeystorePasswordHolder() {
        return this.keystorePasswordHolder;
    }

    public void addNeedUri(UserNeed userNeed) {
        this.userNeeds.add(userNeed);
    }

    public List<UserNeed> getUserNeeds() {
        return this.userNeeds;
    }

    public void setUserNeeds(List<UserNeed> userNeeds) {
        this.userNeeds = userNeeds;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Set<URI> getDraftURIs() {
        return this.draftURIs;
    }

    public void setDrafts(Set<URI> draftURIs) {
        this.draftURIs = draftURIs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        if (this.id != null ? !this.id.equals(user.id) : user.id != null) {
            return false;
        }
        if (this.userNeeds != null ? !this.userNeeds.equals(user.userNeeds) : user.userNeeds != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(user.password) : user.password != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(user.username) : user.username != null) {
            return false;
        }
        if (this.role != null ? !this.role.equals(user.role) : user.role != null) {
            return false;
        }
        return !(this.email != null ? !this.email.equals(user.email) : user.email != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.userNeeds != null ? this.userNeeds.hashCode() : 0);
        result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        return result;
    }
}

