/*
 * Decompiled with CFR 0.152.
 */
package won.owner.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="keystore")
public class KeystoreHolder {
    private static final int DEFAULT_BYTE_ARRAY_SIZE = 500;
    private static final String PROVIDER_BC = "BC";
    private static final String KEY_STORE_TYPE = "UBER";
    @Id
    @GeneratedValue
    @Column(name="id")
    private Long id;
    @Transient
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Lob
    @Column(name="keystore_data", nullable=false, length=10000000)
    private byte[] keystoreBytes;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setKeystoreBytes(byte[] keystoreBytes) {
        this.keystoreBytes = keystoreBytes;
    }

    public byte[] getKeystoreBytes() {
        return this.keystoreBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setKeystore(KeyStore store, String password) throws IOException {
        KeystoreHolder keystoreHolder = this;
        synchronized (keystoreHolder) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(500);
            if (outputStream != null) {
                try {
                    store.store(outputStream, password.toCharArray());
                    this.keystoreBytes = outputStream.toByteArray();
                }
                catch (Exception e) {
                    this.logger.error("Could not save key store " + this.getId(), (Throwable)e);
                    throw new IOException(e);
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (Exception e) {
                        this.logger.error("Error closing stream of keystore " + this.getId(), (Throwable)e);
                        throw e;
                    }
                }
            }
        }
    }

    public synchronized KeyStore getKeystore(String password) throws Exception {
        KeyStore store = null;
        ByteArrayInputStream inputStream = null;
        byte[] keystoreData = this.getKeystoreBytes();
        if (keystoreData == null || keystoreData.length == 0) {
            store = KeyStore.getInstance(KEY_STORE_TYPE, PROVIDER_BC);
            store.load(null, password.toCharArray());
            this.setKeystore(store, password);
            return store;
        }
        inputStream = new ByteArrayInputStream(this.getKeystoreBytes());
        try {
            store = KeyStore.getInstance(KEY_STORE_TYPE, PROVIDER_BC);
            store.load(inputStream, password.toCharArray());
        }
        catch (Exception e) {
            this.logger.error("Could not load key store " + this.getId(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (Exception e) {
                this.logger.error("Error closing stream of keystore " + this.getId(), (Throwable)e);
                throw e;
            }
        }
        return store;
    }
}

