/*
 * Decompiled with CFR 0.152.
 */
package won.owner.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.net.URI;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import won.protocol.model.URIConverter;

@Entity
@Table(name="needDraft", uniqueConstraints={@UniqueConstraint(columnNames={"id", "draftURI"})})
@JsonIgnoreProperties(ignoreUnknown=true)
public class Draft {
    @Id
    @GeneratedValue
    @Column(name="id")
    private Long id;
    @Column(name="draftURI", unique=true)
    @Convert(converter=URIConverter.class)
    private URI draftURI;
    @Column(length=10000)
    private String content;

    public Draft() {
    }

    public Draft(URI draftURI, String content) {
        this.draftURI = draftURI;
        this.content = content;
    }

    public Long getId() {
        return this.id;
    }

    public URI getDraftURI() {
        return this.draftURI;
    }

    public void setDraftURI(URI draftURI) {
        this.draftURI = draftURI;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}

