/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.protocol.impl;

import java.net.URI;
import org.apache.jena.rdf.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.matcher.MatcherProtocolNeedServiceClientSide;
import won.protocol.message.WonMessage;
import won.protocol.model.FacetType;
import won.protocol.util.WonRdfUtils;

public class MatcherProtocolNeedServiceClient
implements MatcherProtocolNeedServiceClientSide {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    MatcherProtocolNeedServiceClientSide delegate;

    public void hint(URI needURI, URI otherNeed, double score, URI originator, Model content, WonMessage wonMessage) throws Exception {
        this.logger.info("need-facing: HINT called for needURI {} and otherNeed {} with score {} from originator {}.", new Object[]{needURI, otherNeed, score, originator});
        Model facetModel = WonRdfUtils.FacetUtils.createFacetModelForHintOrConnect((URI)FacetType.OwnerFacet.getURI(), (URI)FacetType.OwnerFacet.getURI());
        this.delegate.hint(needURI, otherNeed, score, originator, facetModel, wonMessage);
    }

    public void initializeDefault() {
        this.delegate.initializeDefault();
    }

    public void setDelegate(MatcherProtocolNeedServiceClientSide delegate) {
        this.delegate = delegate;
    }
}

