/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.protocol.impl;

import java.net.URI;
import org.apache.jena.query.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.matcher.protocol.MatcherProtocolMatcherService;
import won.matcher.protocol.MatcherProtocolMatcherServiceCallback;
import won.matcher.protocol.NopMatcherProtocolMatcherServiceCallback;

public class MatcherProtocolMatcherServiceImpl
implements MatcherProtocolMatcherService {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=false)
    private MatcherProtocolMatcherServiceCallback matcherServiceCallback = new NopMatcherProtocolMatcherServiceCallback();

    @Override
    public void onMatcherRegistration(URI wonNodeUri) {
        this.logger.debug("matcher registration complete on {} ", (Object)wonNodeUri);
        this.matcherServiceCallback.onRegistered(wonNodeUri);
    }

    @Override
    public void onNewNeed(URI wonNodeURI, URI needURI, Dataset content) {
        this.logger.debug("matcher from need: need created event for needURI {}", (Object)needURI);
        if (needURI == null) {
            throw new IllegalArgumentException("needURI is not set");
        }
        this.matcherServiceCallback.onNewNeed(wonNodeURI, needURI, content);
    }

    @Override
    public void onNeedActivated(URI wonNodeURI, URI needURI) {
        this.logger.debug("matcher from need: need activated event for needURI {}", (Object)needURI);
        if (needURI == null) {
            throw new IllegalArgumentException("needURI is not set");
        }
        this.matcherServiceCallback.onNeedActivated(wonNodeURI, needURI);
    }

    @Override
    public void onNeedDeactivated(URI wonNodeURI, URI needURI) {
        this.logger.debug("matcher from need: need deactivated event for needURI {}", (Object)needURI);
        if (needURI == null) {
            throw new IllegalArgumentException("needURI is not set");
        }
        this.matcherServiceCallback.onNeedDeactivated(wonNodeURI, needURI);
    }
}

