/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.protocol.impl;

import java.net.URI;
import java.util.Set;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.service.RegistrationRestClientHttps;
import won.protocol.exception.CamelConfigurationFailedException;
import won.protocol.exception.NoSuchConnectionException;
import won.protocol.jms.ActiveMQService;
import won.protocol.jms.CamelConfiguration;
import won.protocol.jms.CamelConfigurator;
import won.protocol.jms.MatcherActiveMQService;
import won.protocol.jms.MatcherProtocolCamelConfigurator;
import won.protocol.jms.MatcherProtocolCommunicationService;
import won.protocol.jms.NeedProtocolCamelConfigurator;

public class MatcherProtocolCommunicationServiceImpl
implements MatcherProtocolCommunicationService {
    private RegistrationRestClientHttps registrationClient;
    private MatcherProtocolCamelConfigurator matcherProtocolCamelConfigurator;
    private MatcherActiveMQService activeMQService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void setRegistrationClient(RegistrationRestClientHttps registrationClient) {
        this.registrationClient = registrationClient;
    }

    public synchronized CamelConfiguration configureCamelEndpoint(URI nodeUri, String startingEndpoint) throws Exception {
        CamelConfiguration camelConfiguration = new CamelConfiguration();
        URI needBrokerUri = this.activeMQService.getBrokerEndpoint(nodeUri);
        if (this.matcherProtocolCamelConfigurator.getBrokerComponentNameWithBrokerUri(needBrokerUri) != null) {
            String endpoint = this.matcherProtocolCamelConfigurator.getEndpoint(nodeUri);
            if (endpoint != null) {
                camelConfiguration.setEndpoint(endpoint);
            } else {
                this.matcherProtocolCamelConfigurator.addRouteForEndpoint(startingEndpoint, needBrokerUri);
                String matcherProtocolQueueName = this.activeMQService.getProtocolQueueNameWithResource(nodeUri);
                this.registrationClient.register(nodeUri.toString());
                endpoint = this.matcherProtocolCamelConfigurator.configureCamelEndpointForNeedUri(nodeUri, needBrokerUri, matcherProtocolQueueName);
                camelConfiguration.setEndpoint(endpoint);
            }
            camelConfiguration.setBrokerComponentName(this.matcherProtocolCamelConfigurator.getBrokerComponentNameWithBrokerUri(needBrokerUri));
        } else {
            URI resourceUri = nodeUri;
            URI brokerUri = needBrokerUri;
            String matcherProtocolQueueName = this.activeMQService.getProtocolQueueNameWithResource(resourceUri);
            camelConfiguration.setEndpoint(this.matcherProtocolCamelConfigurator.configureCamelEndpointForNeedUri(resourceUri, brokerUri, matcherProtocolQueueName));
            this.matcherProtocolCamelConfigurator.addRouteForEndpoint(startingEndpoint, brokerUri);
            camelConfiguration.setBrokerComponentName(this.matcherProtocolCamelConfigurator.getBrokerComponentNameWithBrokerUri(brokerUri));
            ActiveMQComponent activeMQComponent = (ActiveMQComponent)this.matcherProtocolCamelConfigurator.getCamelContext().getComponent(this.matcherProtocolCamelConfigurator.getBrokerComponentNameWithBrokerUri(brokerUri));
            this.logger.info("ActiveMQ Service Status : {}", (Object)activeMQComponent.getStatus().toString());
            activeMQComponent.start();
        }
        return camelConfiguration;
    }

    public synchronized Set<String> getMatcherProtocolOutTopics(URI wonNodeURI) {
        Set matcherProtocolTopics = this.activeMQService.getMatcherProtocolTopicNamesWithResource(wonNodeURI);
        return matcherProtocolTopics;
    }

    public synchronized void addRemoteTopicListeners(Set<String> endpoints, URI wonNodeUri) throws CamelConfigurationFailedException {
        try {
            this.registrationClient.register(wonNodeUri.toString());
            URI remoteEndpoint = this.activeMQService.getBrokerEndpoint(wonNodeUri);
            String remoteComponentName = this.matcherProtocolCamelConfigurator.setupBrokerComponentName(remoteEndpoint);
            this.logger.debug("remoteComponentName: {}", (Object)remoteComponentName);
            this.matcherProtocolCamelConfigurator.addCamelComponentForWonNodeBrokerForTopics(remoteEndpoint, remoteComponentName);
            this.matcherProtocolCamelConfigurator.addRemoteTopicListeners(endpoints, remoteEndpoint);
        }
        catch (CamelConfigurationFailedException ex) {
            throw ex;
        }
        catch (Exception e) {
            this.logger.error("Error of security configuration for communication with " + wonNodeUri.toString());
            throw new CamelConfigurationFailedException((Throwable)e);
        }
    }

    public URI getBrokerUri(URI resourceUri) throws NoSuchConnectionException {
        return this.activeMQService.getBrokerEndpoint(resourceUri);
    }

    public ActiveMQService getActiveMQService() {
        return this.activeMQService;
    }

    public void setActiveMQService(ActiveMQService activeMQService) {
        this.activeMQService = (MatcherActiveMQService)activeMQService;
    }

    public CamelConfigurator getProtocolCamelConfigurator() {
        return this.matcherProtocolCamelConfigurator;
    }

    public void setMatcherProtocolCamelConfigurator(NeedProtocolCamelConfigurator matcherProtocolCamelConfigurator) {
        this.matcherProtocolCamelConfigurator = (MatcherProtocolCamelConfigurator)matcherProtocolCamelConfigurator;
    }
}

