/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.messaging;

import java.net.URI;
import java.util.Set;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.camel.Component;
import org.apache.camel.RoutesBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.matcher.camel.routes.Matcher2NodeDynamicRoutes;
import won.matcher.camel.routes.MatcherApplicationListenerRouteBuilder;
import won.protocol.exception.CamelConfigurationFailedException;
import won.protocol.jms.MatcherProtocolCamelConfigurator;
import won.protocol.jms.NeedBasedCamelConfiguratorImpl;
import won.protocol.model.MessagingType;

public class MatcherProtocolCamelConfiguratorImpl
extends NeedBasedCamelConfiguratorImpl
implements MatcherProtocolCamelConfigurator {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public synchronized void addRemoteTopicListeners(Set<String> endpoints, URI remoteEndpoint) throws CamelConfigurationFailedException {
        this.logger.info("length of endpoints {}", (Object)endpoints.size());
        MatcherApplicationListenerRouteBuilder matcherApplicationListenerRouteBuilder = new MatcherApplicationListenerRouteBuilder(this.getCamelContext(), endpoints, remoteEndpoint);
        try {
            this.getCamelContext().addRoutes((RoutesBuilder)matcherApplicationListenerRouteBuilder);
        }
        catch (Exception e) {
            this.logger.debug("adding route to camel context failed", (Throwable)e);
            throw new CamelConfigurationFailedException("adding route to camel context failed", (Throwable)e);
        }
    }

    public synchronized void addCamelComponentForWonNodeBrokerForTopics(URI brokerUri, String brokerComponentName) {
        if (this.getCamelContext().getComponent(brokerComponentName) == null) {
            ActiveMQComponent activeMQComponent = (ActiveMQComponent)this.brokerComponentFactory.getBrokerComponent(brokerUri, MessagingType.Topic, this.getMessagingContext());
            this.logger.info("adding activemqComponent for brokerUri {} with brokerComponentName {}", (Object)brokerUri, (Object)brokerComponentName);
            this.getCamelContext().addComponent(brokerComponentName, (Component)activeMQComponent);
            try {
                activeMQComponent.start();
            }
            catch (Exception e) {
                this.logger.warn("could not start activemq", (Throwable)e);
            }
        }
        this.brokerComponentMap.put((Object)brokerUri, (Object)brokerComponentName);
    }

    protected RoutesBuilder createRoutesBuilder(String startingEndpoint, URI brokerUri) {
        return new Matcher2NodeDynamicRoutes(this.getCamelContext(), startingEndpoint);
    }
}

