/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.protocol.impl;

import java.net.URI;
import java.util.HashMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.jms.CamelConfiguration;
import won.protocol.jms.MatcherProtocolCommunicationService;
import won.protocol.jms.MessagingService;
import won.protocol.matcher.MatcherProtocolNeedServiceClientSide;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageEncoder;
import won.protocol.util.RdfUtils;

public class MatcherProtocolNeedServiceClientJMSBased
implements MatcherProtocolNeedServiceClientSide {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private MessagingService messagingService;
    private MatcherProtocolCommunicationService matcherProtocolCommunicationService;
    private String startingEndpoint;

    public void hint(URI needURI, URI otherNeed, double score, URI originator, Model content, WonMessage wonMessage) throws Exception {
        this.logger.info("need-facing: HINT called for needURI {} and otherNeed {} with score {} from originator {}.", new Object[]{needURI, otherNeed, score, originator});
        CamelConfiguration camelConfiguration = this.matcherProtocolCommunicationService.configureCamelEndpoint(wonMessage.getReceiverNodeURI(), this.startingEndpoint);
        String endpoint = camelConfiguration.getEndpoint();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("needURI", needURI.toString());
        headerMap.put("otherNeedURI", otherNeed.toString());
        headerMap.put("score", String.valueOf(score));
        headerMap.put("originator", originator.toString());
        headerMap.put("content", RdfUtils.toString((Model)content));
        headerMap.put("remoteBrokerEndpoint", endpoint);
        headerMap.put("methodName", "hint");
        this.messagingService.sendInOnlyMessage(null, headerMap, (Object)WonMessageEncoder.encode((WonMessage)wonMessage, (Lang)Lang.TRIG), this.startingEndpoint);
    }

    public void initializeDefault() {
    }

    public void setStartingEndpoint(String startingEndpoint) {
        this.startingEndpoint = startingEndpoint;
    }

    public MessagingService getMessagingService() {
        return this.messagingService;
    }

    public void setMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    public MatcherProtocolCommunicationService getMatcherProtocolCommunicationService() {
        return this.matcherProtocolCommunicationService;
    }

    public void setMatcherProtocolCommunicationService(MatcherProtocolCommunicationService matcherProtocolCommunicationService) {
        this.matcherProtocolCommunicationService = matcherProtocolCommunicationService;
    }
}

