/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.utils.tensor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.la4j.Matrices;
import org.la4j.matrix.sparse.CCSMatrix;
import org.la4j.vector.functor.VectorProcedure;

public class ThirdOrderSparseTensor {
    private ArrayList<CCSMatrix> slices = new ArrayList();
    private int[] dims = null;

    public ThirdOrderSparseTensor(int dimX1, int dimX2) {
        this.resize(dimX1, dimX2);
    }

    public void resize(int dimX1, int dimX2) {
        for (int x3 = 0; x3 < this.slices.size(); ++x3) {
            if (this.slices.get(x3) == null) continue;
            this.slices.set(x3, (CCSMatrix)this.slices.get(x3).copyOfShape(dimX1, dimX2).to(Matrices.CCS));
        }
        this.dims = new int[]{dimX1, dimX2, this.slices.size()};
    }

    public void setEntry(double value, int x1, int x2, int x3) {
        if (this.slices.size() <= x3) {
            for (int i = this.slices.size(); i <= x3; ++i) {
                this.slices.add(i, CCSMatrix.zero((int)this.dims[0], (int)this.dims[1]));
            }
            this.dims = new int[]{this.dims[0], this.dims[1], this.slices.size()};
        }
        this.slices.get(x3).set(x1, x2, value);
    }

    public double getEntry(int x1, int x2, int x3) {
        return this.slices.get(x3).get(x1, x2);
    }

    public int getNonZeroEntries(int dimX3) {
        return this.slices.get(dimX3).cardinality();
    }

    public int[] getDimensions() {
        return this.dims;
    }

    public void writeSliceToFile(String fileName, int slice) throws IOException {
        FileOutputStream os = new FileOutputStream(new File(fileName));
        NumberFormat format = DecimalFormat.getInstance(Locale.US);
        ((OutputStream)os).write(this.slices.get(slice).toMatrixMarket(format).replace("column-major", "").getBytes());
    }

    public Collection<Integer> getNonZeroIndicesOfRow(int x1, int x3) {
        NonZeroVectorProcedure nz = new NonZeroVectorProcedure();
        this.slices.get(x3).eachNonZeroInRow(x1, (VectorProcedure)nz);
        return nz.getNonZeroIndices();
    }

    public boolean hasNonZeroEntryInRow(int x1, int x3) {
        return this.slices.get(x3).getRow(x1).max() > 0.0;
    }

    private class NonZeroVectorProcedure
    implements VectorProcedure {
        private List<Integer> nonZeroIndices = new LinkedList<Integer>();

        public void apply(int i, double value) {
            this.nonZeroIndices.add(i);
        }

        public Collection<Integer> getNonZeroIndices() {
            return this.nonZeroIndices;
        }
    }
}

