/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.utils.tensor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.matcher.utils.tensor.TensorEntry;
import won.matcher.utils.tensor.ThirdOrderSparseTensor;

public class TensorMatchingData {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int MAX_DIMENSION = 1000000;
    public static final String HEADERS_FILE = "headers.txt";
    public static final String ATOM_INDICES_FILE = "atomIndices.txt";
    public static final String CONNECTION_SLICE_NAME = "connection";
    private ThirdOrderSparseTensor tensor = new ThirdOrderSparseTensor(1000000, 1000000);
    private ArrayList<String> atoms = new ArrayList();
    private ArrayList<String> attributes = new ArrayList();
    private ArrayList<String> slices = new ArrayList();
    private int nextIndex = 0;

    public void addAtomConnection(String atom1, String atom2, boolean addOnlyIfAtomsExist) {
        this.checkAttributeOrAtomName(atom1);
        this.checkAttributeOrAtomName(atom2);
        if (!addOnlyIfAtomsExist || addOnlyIfAtomsExist && this.atoms.contains(atom1) && this.atoms.contains(atom2)) {
            int x1 = this.addAtom(atom1);
            int x2 = this.addAtom(atom2);
            int x3 = this.addSlice(CONNECTION_SLICE_NAME);
            this.tensor.setEntry(1.0, x1, x2, x3);
            this.tensor.setEntry(1.0, x2, x1, x3);
        }
    }

    public void addAtomAttribute(String sliceName, String atomUri, String attributeValue) {
        this.checkAttributeOrAtomName(atomUri);
        this.checkAttributeOrAtomName(attributeValue);
        this.checkSliceName(sliceName, false);
        int x1 = this.addAtom(atomUri);
        int x2 = this.addAttribute(attributeValue);
        int x3 = this.addSlice(sliceName);
        this.tensor.setEntry(1.0, x1, x2, x3);
    }

    public void addAtomAttribute(TensorEntry entry) {
        this.addAtomAttribute(entry.getSliceName(), entry.getAtomUri(), entry.getValue());
    }

    public String getFirstAttributeOfAtom(String atom, String slice) {
        int atomIndex = this.atoms.indexOf(atom);
        if (atomIndex < 0) {
            return null;
        }
        Iterator<Integer> iter = this.tensor.getNonZeroIndicesOfRow(atomIndex, this.slices.indexOf(slice)).iterator();
        if (iter.hasNext()) {
            return this.attributes.get(iter.next());
        }
        return null;
    }

    public boolean isValidTensor() {
        return this.atoms.size() > 0 && this.attributes.size() > 0 && this.slices.size() > 0 && this.getSliceIndex(CONNECTION_SLICE_NAME) != -1;
    }

    public int[] getTensorDimensions() {
        return this.tensor.getDimensions();
    }

    protected TensorMatchingData removeEmptyAtomsAndConnections() {
        String atom;
        int i;
        TensorMatchingData cleanedMatchingData = new TensorMatchingData();
        for (i = 0; i < this.atoms.size(); ++i) {
            atom = this.atoms.get(i);
            if (atom == null || !this.atomHasAttributes(i)) continue;
            cleanedMatchingData.addAtom(atom);
        }
        for (i = 0; i < this.atoms.size(); ++i) {
            atom = this.atoms.get(i);
            if (atom == null || !this.atomHasAttributes(i)) continue;
            for (int sliceIndex = 0; sliceIndex < this.slices.size(); ++sliceIndex) {
                for (int attrIndex : this.tensor.getNonZeroIndicesOfRow(i, sliceIndex)) {
                    if (this.slices.get(sliceIndex).equals(CONNECTION_SLICE_NAME)) {
                        cleanedMatchingData.addAtomConnection(atom, this.atoms.get(attrIndex), true);
                        continue;
                    }
                    cleanedMatchingData.addAtomAttribute(this.slices.get(sliceIndex), atom, this.attributes.get(attrIndex));
                }
            }
        }
        return cleanedMatchingData;
    }

    private int addAtom(String atom) {
        if (!this.atoms.contains(atom)) {
            this.atoms.add(this.nextIndex, atom);
            this.attributes.add(this.nextIndex, null);
            ++this.nextIndex;
        }
        return this.atoms.indexOf(atom);
    }

    private int addAttribute(String attr) {
        if (!this.attributes.contains(attr)) {
            this.attributes.add(this.nextIndex, attr);
            this.atoms.add(this.nextIndex, null);
            ++this.nextIndex;
        }
        return this.attributes.indexOf(attr);
    }

    private int addSlice(String slice) {
        if (!this.slices.contains(slice)) {
            this.slices.add(slice);
        }
        return this.slices.indexOf(slice);
    }

    private void checkAttributeOrAtomName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Atom/Attribute is not allowed to be null or empty");
        }
    }

    private void checkSliceName(String name, boolean connectionSlice) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Slice is not allowed to be null or empty");
        }
        if (connectionSlice && !name.equals(CONNECTION_SLICE_NAME) || !connectionSlice && name.equals(CONNECTION_SLICE_NAME)) {
            throw new IllegalArgumentException("Only connection slice is allowed the name: 'connection' ");
        }
    }

    protected ThirdOrderSparseTensor getTensor() {
        return this.tensor;
    }

    protected ThirdOrderSparseTensor createFinalTensor() {
        int dim = this.getAtoms().size() + this.getAttributes().size();
        this.tensor.resize(dim, dim);
        return this.tensor;
    }

    protected int getSliceIndex(String sliceName) {
        return this.slices.indexOf(sliceName);
    }

    private boolean atomHasAttributes(int atomIndex) {
        for (int i = 0; i < this.slices.size(); ++i) {
            if (!this.tensor.hasNonZeroEntryInRow(atomIndex, i) || this.getSliceIndex(CONNECTION_SLICE_NAME) == i) continue;
            return true;
        }
        return false;
    }

    public ArrayList<String> getAtomHeaders() {
        return (ArrayList)this.atoms.clone();
    }

    public List<String> getAtoms() {
        ArrayList<String> continuousList = new ArrayList<String>();
        for (String atom : this.atoms) {
            if (atom == null) continue;
            continuousList.add(atom);
        }
        return continuousList;
    }

    public List<String> getAttributes() {
        ArrayList<String> continuousList = new ArrayList<String>();
        for (String attr : this.attributes) {
            if (attr == null) continue;
            continuousList.add(attr);
        }
        return continuousList;
    }

    public List<String> getSlices() {
        ArrayList<String> continuousList = new ArrayList<String>(this.slices);
        return continuousList;
    }

    public int getNumberOfConnections() {
        int connectionSlice = this.getSliceIndex(CONNECTION_SLICE_NAME);
        return connectionSlice != -1 ? this.getTensor().getNonZeroEntries(connectionSlice) / 2 : 0;
    }

    public TensorMatchingData writeCleanedOutputFiles(String folder) throws IOException {
        if (!this.isValidTensor()) {
            throw new IllegalStateException("Tensor must filled with data before it can be written");
        }
        logger.info("remove empty atoms and connections ...");
        TensorMatchingData cleanedMatchingData = this.removeEmptyAtomsAndConnections();
        logger.info("Number of atoms before cleaning: " + this.getAtoms().size());
        logger.info("Number of atoms after cleaning: " + cleanedMatchingData.getAtoms().size());
        logger.info("Number of attributes before cleaning: " + this.getAttributes().size());
        logger.info("Number of attributes after cleaning: " + cleanedMatchingData.getAttributes().size());
        logger.info("Number of connections before cleaning: " + this.getNumberOfConnections());
        logger.info("Number of connections after cleaning: " + cleanedMatchingData.getNumberOfConnections());
        cleanedMatchingData.writeOutputFiles(folder);
        return cleanedMatchingData;
    }

    public void writeOutputFiles(String folder) throws IOException {
        int i;
        File outFolder = new File(folder);
        outFolder.mkdirs();
        if (!outFolder.isDirectory()) {
            return;
        }
        logger.info("create final tensor ...");
        this.createFinalTensor();
        int dim = this.tensor.getDimensions()[0];
        if (dim > 1000000) {
            logger.error("Maximum Dimension {} exceeded: {}", (Object)1000000, (Object)dim);
            return;
        }
        logger.info("create tensor data in folder: {}", (Object)folder);
        for (int sliceIndex = 0; sliceIndex < this.slices.size(); ++sliceIndex) {
            logger.info("- " + this.slices.get(sliceIndex) + ".mtx");
            this.tensor.writeSliceToFile(folder + "/" + this.slices.get(sliceIndex) + ".mtx", sliceIndex);
        }
        FileOutputStream fos = new FileOutputStream(new File(folder + "/" + HEADERS_FILE));
        OutputStreamWriter os = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        for (i = 0; i < this.nextIndex; ++i) {
            String entity = this.atoms.get(i) != null ? this.atoms.get(i) : this.attributes.get(i);
            os.append(entity).append("\n");
        }
        os.close();
        fos = new FileOutputStream(new File(folder + "/" + ATOM_INDICES_FILE));
        os = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        for (i = 0; i < this.nextIndex; ++i) {
            if (this.atoms.get(i) == null) continue;
            os.append(String.valueOf(i)).append("\n");
        }
        os.close();
        logger.info("- atoms: {}", (Object)this.getAtoms().size());
        logger.info("- attributes: {}", (Object)this.getAttributes().size());
        logger.info("- connections: {}", (Object)(this.tensor.getNonZeroEntries(this.slices.indexOf(CONNECTION_SLICE_NAME)) / 2));
        logger.info("- tensor size: {} x {} x " + this.tensor.getDimensions()[2], (Object)this.tensor.getDimensions()[0], (Object)this.tensor.getDimensions()[1]);
    }
}

