/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.utils.tensor;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import won.matcher.utils.preprocessing.OpenNlpTokenExtraction;
import won.matcher.utils.tensor.TensorEntry;
import won.matcher.utils.tensor.TensorEntryGenerator;

public class TensorEntryTokenizer
implements TensorEntryGenerator {
    private OpenNlpTokenExtraction tokenizer;
    private Collection<TensorEntry> tensorEntries;

    public TensorEntryTokenizer(Collection<TensorEntry> tensorEntries) throws IOException {
        this.tensorEntries = tensorEntries;
        this.tokenizer = new OpenNlpTokenExtraction();
    }

    @Override
    public Collection<TensorEntry> generateTensorEntries() throws IOException {
        LinkedList<TensorEntry> tokenEntries = new LinkedList<TensorEntry>();
        for (TensorEntry entry : this.tensorEntries) {
            String[] tokens;
            for (String token : tokens = this.tokenizer.extractWordTokens(entry.getValue())) {
                TensorEntry newEntry = new TensorEntry(entry.getSliceName(), entry.getAtomUri(), token);
                tokenEntries.add(newEntry);
            }
        }
        return tokenEntries;
    }
}

