/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.utils.tensor;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.RDFNode;
import won.matcher.utils.tensor.TensorEntry;
import won.matcher.utils.tensor.TensorEntryGenerator;
import won.protocol.exception.DataIntegrityException;

public class TensorEntrySparqlGenerator
implements TensorEntryGenerator {
    private String sparqlEndpoint;
    private String query;
    private Map<String, Object> parameterBindings;
    private static String[] variableNames = new String[]{"slice", "atom", "value"};

    public TensorEntrySparqlGenerator(String sparqlEndpoint, String sparqlQuery) {
        this.sparqlEndpoint = sparqlEndpoint;
        this.query = sparqlQuery;
        this.parameterBindings = new HashMap<String, Object>();
    }

    public void addVariableBinding(String var, Object value) {
        this.parameterBindings.put(var, value);
    }

    @Override
    public Collection<TensorEntry> generateTensorEntries() {
        LinkedList<TensorEntry> tensorEntries = new LinkedList<TensorEntry>();
        ParameterizedSparqlString pss = new ParameterizedSparqlString();
        pss.setCommandText(this.query);
        for (String key : this.parameterBindings.keySet()) {
            Object value = this.parameterBindings.get(key);
            if (value instanceof String) {
                pss.setLiteral(key, (String)value);
                continue;
            }
            if (value instanceof Long || value instanceof Integer) {
                pss.setLiteral(key, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Float || value instanceof Double) {
                pss.setLiteral(key, ((Double)value).doubleValue());
                continue;
            }
            throw new IllegalArgumentException("Variable must be of type String/Long/Integer/Float/Double");
        }
        Query q = pss.asQuery();
        try (QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.sparqlEndpoint, (Query)q);){
            ResultSet results = qexec.execSelect();
            if (!results.getResultVars().containsAll(Arrays.asList(variableNames))) {
                throw new DataIntegrityException("sparql query is expected to return variables: " + variableNames);
            }
            while (results.hasNext()) {
                TensorEntry entry = new TensorEntry();
                QuerySolution qs = results.next();
                RDFNode node = qs.get("slice");
                entry.setSliceName(node.isResource() ? node.asResource().getURI() : node.asLiteral().getString());
                node = qs.get("atom");
                entry.setAtomUri(node.isResource() ? node.asResource().getURI() : node.asLiteral().getString());
                node = qs.get("value");
                entry.setValue(node.isResource() ? node.asResource().getURI() : node.asLiteral().getString());
                tensorEntries.add(entry);
            }
            LinkedList<TensorEntry> linkedList = tensorEntries;
            return linkedList;
        }
    }
}

