/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.utils.tensor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import won.matcher.utils.tensor.TensorEntry;
import won.matcher.utils.tensor.TensorEntryGenerator;
import won.matcher.utils.tensor.TensorEntrySparqlGenerator;

public class TensorEntryAllGenerator
implements TensorEntryGenerator {
    private String sparqlEndpoint;
    private String queryDirectory;
    private long from;
    private long to;

    public TensorEntryAllGenerator(String queryDirectory, String sparqlEndpoint, long fromDate, long toDate) {
        this.queryDirectory = queryDirectory;
        this.sparqlEndpoint = sparqlEndpoint;
        this.from = fromDate;
        this.to = toDate;
    }

    @Override
    public Collection<TensorEntry> generateTensorEntries() throws IOException {
        LinkedList<TensorEntry> tensorEntries = new LinkedList<TensorEntry>();
        LinkedList<TensorEntrySparqlGenerator> queryGenerators = new LinkedList<TensorEntrySparqlGenerator>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resolver.getResources("classpath:" + this.queryDirectory + "/*.rq");
        for (Resource resource : resources) {
            String query = TensorEntryAllGenerator.readFromInputStream(resource.getInputStream());
            TensorEntrySparqlGenerator queryGen = new TensorEntrySparqlGenerator(this.sparqlEndpoint, query);
            queryGen.addVariableBinding("from", this.from);
            queryGen.addVariableBinding("to", this.to);
            queryGenerators.add(queryGen);
        }
        for (TensorEntrySparqlGenerator queryGen : queryGenerators) {
            tensorEntries.addAll(queryGen.generateTensorEntries());
        }
        return tensorEntries;
    }

    public static String readFromInputStream(InputStream input) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input, "UTF-8"));){
            String string = buffer.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }
}

