/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.solr.query.factory;

import java.util.Collection;
import java.util.LinkedList;
import won.matcher.solr.query.factory.BooleanQueryFactory;
import won.matcher.solr.query.factory.ExactMatchFieldQueryFactory;
import won.matcher.solr.query.factory.SolrQueryFactory;

public class MatchingContextQueryFactory
extends SolrQueryFactory {
    public static final String MATCHING_CONTEXT_SOLR_FIELD = "_graph.http___purl.org_webofneeds_model_hasMatchingContext";
    Collection<String> matchingContexts;

    public MatchingContextQueryFactory(Collection<String> matchingContexts) {
        this.matchingContexts = matchingContexts;
    }

    @Override
    protected String makeQueryString() {
        if (this.matchingContexts == null) {
            return "";
        }
        LinkedList<ExactMatchFieldQueryFactory> contextFactories = new LinkedList<ExactMatchFieldQueryFactory>();
        for (String context : this.matchingContexts) {
            contextFactories.add(new ExactMatchFieldQueryFactory(MATCHING_CONTEXT_SOLR_FIELD, context));
        }
        BooleanQueryFactory booleanQueryFactory = new BooleanQueryFactory(BooleanQueryFactory.BooleanOperator.OR, contextFactories.toArray(new ExactMatchFieldQueryFactory[contextFactories.size()]));
        return booleanQueryFactory.makeQueryString();
    }
}

