/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.solr.query.factory;

import won.matcher.solr.query.factory.SolrQueryFactory;

public class BooleanQueryFactory
extends SolrQueryFactory {
    private SolrQueryFactory[] factories;
    private BooleanOperator operator;

    public BooleanQueryFactory(BooleanOperator op, SolrQueryFactory ... factories) {
        this.operator = op;
        this.factories = factories;
    }

    @Override
    protected String makeQueryString() {
        StringBuilder queryBuilder = new StringBuilder();
        if (this.operator.equals((Object)BooleanOperator.NOT) && this.factories.length > 0) {
            queryBuilder.append(" NOT (");
            queryBuilder.append(this.factories[0].createQuery());
            queryBuilder.append(") ");
        } else {
            for (int i = 0; i < this.factories.length; ++i) {
                queryBuilder.append(" (");
                queryBuilder.append(this.factories[i].createQuery());
                queryBuilder.append(") ");
                if (i >= this.factories.length - 1) continue;
                queryBuilder.append(this.operator.toString());
                queryBuilder.append("\n");
            }
        }
        return queryBuilder.toString();
    }

    public static enum BooleanOperator {
        AND,
        OR,
        NOT;

    }
}

