/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.solr.query.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.matcher.solr.query.factory.BooleanQueryFactory;
import won.matcher.solr.query.factory.GeoDistBoostQueryFactory;
import won.matcher.solr.query.factory.MatchFieldQueryFactory;
import won.matcher.solr.query.factory.MultiplicativeBoostQueryFactory;
import won.matcher.solr.query.factory.NeedDatasetQueryFactory;
import won.matcher.solr.query.factory.SolrQueryFactory;
import won.protocol.model.Coordinate;
import won.protocol.model.NeedContentPropertyType;
import won.protocol.util.DefaultNeedModelWrapper;

public class BasicNeedQueryFactory
extends NeedDatasetQueryFactory {
    public static final Map<NeedContentPropertyType, String> titleFieldMap = new HashMap<NeedContentPropertyType, String>();
    public static final Map<NeedContentPropertyType, String> descriptionFieldMap;
    public static final Map<NeedContentPropertyType, String> tagFieldMap;
    public static final Map<NeedContentPropertyType, String> locationFieldMap;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ArrayList<SolrQueryFactory> contentFactories = new ArrayList();
    protected ArrayList<SolrQueryFactory> locationFactories = new ArrayList();
    protected DefaultNeedModelWrapper needModelWrapper;

    public BasicNeedQueryFactory(Dataset need) {
        super(need);
        this.needModelWrapper = new DefaultNeedModelWrapper(need);
    }

    public void addTermsToTitleQuery(String terms, NeedContentPropertyType fieldType, double boost) {
        if ((terms = this.filterCharsAndKeyWords(terms)) != null && !terms.trim().isEmpty()) {
            String field = titleFieldMap.get(fieldType);
            MatchFieldQueryFactory qf = new MatchFieldQueryFactory(field, terms);
            qf.setBoost(boost);
            this.contentFactories.add(qf);
        }
    }

    public void addTermsToDescriptionQuery(String terms, NeedContentPropertyType fieldType, double boost) {
        if ((terms = this.filterCharsAndKeyWords(terms)) != null && !terms.trim().isEmpty()) {
            String field = descriptionFieldMap.get(fieldType);
            MatchFieldQueryFactory qf = new MatchFieldQueryFactory(field, terms);
            qf.setBoost(boost);
            this.contentFactories.add(qf);
        }
    }

    public void addTermsToTagQuery(String terms, NeedContentPropertyType fieldType, double boost) {
        if ((terms = this.filterCharsAndKeyWords(terms)) != null && !terms.trim().isEmpty()) {
            String field = tagFieldMap.get(fieldType);
            MatchFieldQueryFactory qf = new MatchFieldQueryFactory(field, terms);
            qf.setBoost(boost);
            this.contentFactories.add(qf);
        }
    }

    public void addLocationFilters(Resource contentNode, NeedContentPropertyType fieldType) {
        Coordinate coordinate = this.needModelWrapper.getLocationCoordinate(contentNode);
        if (coordinate != null) {
            this.locationFactories.add(new GeoDistBoostQueryFactory(locationFieldMap.get(fieldType), coordinate.getLatitude(), coordinate.getLongitude()));
        }
    }

    private String filterCharsAndKeyWords(String text) {
        if (text == null) {
            return null;
        }
        text = text.replaceAll("[^A-Za-z ]", " ");
        text = text.replaceAll("[^A-Za-z ]", " ");
        text = text.replaceAll("NOT ", " ");
        text = text.replaceAll("AND ", " ");
        text = text.replaceAll("OR ", " ");
        text = text.replaceAll(" NOT", " ");
        text = text.replaceAll(" AND", " ");
        text = text.replaceAll(" OR", " ");
        text = text.replaceAll("\\s+", " ");
        return text;
    }

    @Override
    protected String makeQueryString() {
        if (this.contentFactories.size() == 0) {
            return null;
        }
        String boostQueryString = "";
        if (this.locationFactories.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("sum(1");
            for (SolrQueryFactory queryFactory : this.locationFactories) {
                sb.append(",").append(queryFactory.makeQueryString());
            }
            sb.append(")");
            MultiplicativeBoostQueryFactory boostQueryFactory = new MultiplicativeBoostQueryFactory(sb.toString());
            boostQueryString = boostQueryFactory.makeQueryString();
        }
        SolrQueryFactory[] contentArray = new SolrQueryFactory[this.contentFactories.size()];
        BooleanQueryFactory contentQuery = new BooleanQueryFactory(BooleanQueryFactory.BooleanOperator.OR, this.contentFactories.toArray(contentArray));
        return boostQueryString + contentQuery;
    }

    static {
        titleFieldMap.put(NeedContentPropertyType.IS, "_graph.http___purl.org_webofneeds_model_is.http___purl.org_dc_elements_1.1_title");
        titleFieldMap.put(NeedContentPropertyType.SEEKS, "_graph.http___purl.org_webofneeds_model_seeks.http___purl.org_dc_elements_1.1_title");
        titleFieldMap.put(NeedContentPropertyType.SEEKS_SEEKS, "_graph.http___purl.org_webofneeds_model_seeks.http___purl.org_webofneeds_model_seeks.http___purl.org_dc_elements_1.1_title");
        descriptionFieldMap = new HashMap<NeedContentPropertyType, String>();
        descriptionFieldMap.put(NeedContentPropertyType.IS, "_graph.http___purl.org_webofneeds_model_is.http___purl.org_dc_elements_1.1_description");
        descriptionFieldMap.put(NeedContentPropertyType.SEEKS, "_graph.http___purl.org_webofneeds_model_seeks.http___purl.org_dc_elements_1.1_description");
        descriptionFieldMap.put(NeedContentPropertyType.SEEKS_SEEKS, "_graph.http___purl.org_webofneeds_model_seeks.http___purl.org_webofneeds_model_seeks.http___purl.org_dc_elements_1.1_description");
        tagFieldMap = new HashMap<NeedContentPropertyType, String>();
        tagFieldMap.put(NeedContentPropertyType.IS, "_graph.http___purl.org_webofneeds_model_is.http___purl.org_webofneeds_model_hasTag");
        tagFieldMap.put(NeedContentPropertyType.SEEKS, "_graph.http___purl.org_webofneeds_model_seeks.http___purl.org_webofneeds_model_hasTag");
        tagFieldMap.put(NeedContentPropertyType.SEEKS_SEEKS, "_graph.http___purl.org_webofneeds_model_seeks.http___purl.org_webofneeds_model_seeks.http___purl.org_webofneeds_model_hasTag");
        locationFieldMap = new HashMap<NeedContentPropertyType, String>();
        locationFieldMap.put(NeedContentPropertyType.IS, "is_need_location");
        locationFieldMap.put(NeedContentPropertyType.SEEKS, "seeks_need_location");
        locationFieldMap.put(NeedContentPropertyType.SEEKS_SEEKS, "seeksSeeks_need_location");
    }
}

