/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.solr.query;

import java.io.IOException;
import javax.annotation.PostConstruct;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import won.matcher.solr.config.SolrMatcherConfig;
import won.matcher.solr.query.SolrMatcherQueryExecutor;

@Component
public class DefaultMatcherQueryExecuter
implements SolrMatcherQueryExecutor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    SolrMatcherConfig config;
    SolrClient solrClient;

    @PostConstruct
    private void init() {
        this.solrClient = new HttpSolrClient.Builder(this.config.getSolrEndpointUri(false)).build();
    }

    @Override
    public SolrDocumentList executeNeedQuery(String queryString, int maxHints, SolrParams params, String ... filterQueries) throws IOException, SolrServerException {
        if (queryString == null) {
            this.log.debug("query string is null, do execute any query!");
            return null;
        }
        SolrQuery query = new SolrQuery();
        this.log.debug("use query: {} with filters {}", (Object)queryString, (Object)filterQueries);
        query.setQuery(queryString);
        query.setFields(new String[]{"id", "score", "_graph.http___purl.org_webofneeds_model_hasWonNode._id", "_graph.http___purl.org_webofneeds_model_hasFlag._id", "_graph.http___purl.org_webofneeds_model_hasMatchingContext"});
        query.setRows(Integer.valueOf(maxHints));
        if (filterQueries != null) {
            query.setFilterQueries(filterQueries);
        }
        if (params != null) {
            query.add(params);
        }
        try {
            QueryResponse response = this.solrClient.query((SolrParams)query);
            return response.getResults();
        }
        catch (SolrException e) {
            this.log.warn("Exception {} thrown for query: {}", (Object)e, (Object)queryString);
            return null;
        }
    }
}

