/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.solr.hints;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import won.matcher.service.common.event.BulkHintEvent;
import won.matcher.service.common.event.HintEvent;
import won.matcher.service.common.event.NeedEvent;
import won.matcher.solr.config.SolrMatcherConfig;
import won.matcher.solr.utils.Kneedle;
import won.protocol.util.NeedModelWrapper;
import won.protocol.vocabulary.WON;

@Component
public class HintBuilder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String WON_NODE_SOLR_FIELD = "_graph.http___purl.org_webofneeds_model_hasWonNode._id";
    public static final String HAS_FLAG_SOLR_FIELD = "_graph.http___purl.org_webofneeds_model_hasFlag._id";
    @Autowired
    private SolrMatcherConfig config;

    public SolrDocumentList calculateMatchingResults(SolrDocumentList docs) {
        SolrDocumentList matches = new SolrDocumentList();
        if (docs == null || docs.size() == 0) {
            return matches;
        }
        if (this.log.isDebugEnabled()) {
            for (SolrDocument doc : docs) {
                String needUri = doc.getFieldValue("id").toString();
                double score = Double.valueOf(doc.getFieldValue("score").toString());
                this.log.debug("retrieved match {} from Solr score {}: ", (Object)needUri, (Object)score);
            }
        }
        SolrDocumentList sortedDocs = (SolrDocumentList)docs.clone();
        sortedDocs.sort((Comparator)new Comparator<SolrDocument>(){

            @Override
            public int compare(SolrDocument o1, SolrDocument o2) {
                if (((Float)o1.getFieldValue("score")).floatValue() < ((Float)o2.getFieldValue("score")).floatValue()) {
                    return -1;
                }
                if (((Float)o1.getFieldValue("score")).floatValue() > ((Float)o2.getFieldValue("score")).floatValue()) {
                    return 1;
                }
                return 0;
            }
        });
        double cutScoreLowerThan = 0.0;
        if (sortedDocs.size() > 1) {
            Kneedle kneedle = new Kneedle();
            double[] x = new double[sortedDocs.size()];
            double[] y = new double[sortedDocs.size()];
            for (int i = 0; i < sortedDocs.size(); ++i) {
                x[i] = i;
                y[i] = Double.valueOf(((SolrDocument)sortedDocs.get(i)).getFieldValue("score").toString());
            }
            int[] elbows = kneedle.detectElbowPoints(x, y);
            if (elbows.length >= this.config.getCutAfterIthElbowInScore()) {
                cutScoreLowerThan = y[elbows[elbows.length - this.config.getCutAfterIthElbowInScore()]];
                this.log.debug("Calculated elbow score point after {} elbows for document scores: {}", (Object)this.config.getCutAfterIthElbowInScore(), (Object)cutScoreLowerThan);
            }
        }
        for (int i = sortedDocs.size() - 1; i >= 0; --i) {
            double score = Double.valueOf(((SolrDocument)sortedDocs.get(i)).getFieldValue("score").toString());
            if (score < (double)this.config.getScoreThreshold() || score <= cutScoreLowerThan) {
                this.log.debug("cut result documents, current score is {}, score threshold is {}", (Object)score, (Object)Float.valueOf(this.config.getScoreThreshold()));
                break;
            }
            SolrDocument newDoc = (SolrDocument)sortedDocs.get(i);
            matches.add((Object)newDoc);
        }
        return matches;
    }

    public BulkHintEvent generateHintsFromSearchResult(SolrDocumentList docs, NeedEvent need, NeedModelWrapper needModelWrapper, boolean doSuppressHintForNeed, boolean doSuppressHintForMatchedNeeds, boolean kneeDetection) {
        SolrDocumentList newDocs = docs;
        if (kneeDetection) {
            newDocs = this.calculateMatchingResults(docs);
        }
        BulkHintEvent bulkHintEvent = new BulkHintEvent();
        this.log.info("Received {} matches as query result for need {}, keeping the top {} ", new Object[]{docs != null ? docs.size() : 0, need, newDocs.size()});
        boolean noHintForMe = needModelWrapper.hasFlag(WON.NO_HINT_FOR_ME);
        boolean noHintForCounterpart = needModelWrapper.hasFlag(WON.NO_HINT_FOR_COUNTERPART);
        this.log.debug("need to be matched has NoHintForMe: {}, NoHintForCounterpart: {} ", (Object)noHintForMe, (Object)noHintForCounterpart);
        for (SolrDocument doc : newDocs) {
            LinkedList matchingContexts;
            String matchedNeedUri = doc.getFieldValue("id").toString();
            if (matchedNeedUri == null) {
                this.log.debug("omitting matched need: could not extract need URI");
                continue;
            }
            List<String> flags = this.getValueList(doc, HAS_FLAG_SOLR_FIELD);
            boolean matchedNeedNoHintForMe = flags.contains(WON.NO_HINT_FOR_ME.toString());
            boolean matchedNeedNoHintForCounterpart = flags.contains(WON.NO_HINT_FOR_COUNTERPART.toString());
            Collection contextSolrFieldValues = doc.getFieldValues("_graph.http___purl.org_webofneeds_model_hasMatchingContext");
            Collection matchedNeedMatchingContexts = new LinkedList();
            if (contextSolrFieldValues != null) {
                matchedNeedMatchingContexts = contextSolrFieldValues.stream().map(a -> (String)a).collect(Collectors.toList());
            }
            if ((matchingContexts = needModelWrapper.getMatchingContexts()) == null) {
                matchingContexts = new LinkedList();
            }
            boolean contextOverlap = CollectionUtils.intersection(matchedNeedMatchingContexts, (Collection)matchingContexts).size() > 0;
            boolean suppressHintsForMyContexts = !contextOverlap && !CollectionUtils.isEmpty(matchingContexts);
            boolean suppressHintsForCounterpartContexts = !contextOverlap && !CollectionUtils.isEmpty(matchedNeedMatchingContexts);
            doSuppressHintForNeed = noHintForMe || matchedNeedNoHintForCounterpart || doSuppressHintForNeed || suppressHintsForMyContexts;
            boolean bl = doSuppressHintForMatchedNeeds = noHintForCounterpart || matchedNeedNoHintForMe || doSuppressHintForMatchedNeeds || suppressHintsForCounterpartContexts;
            if (this.log.isDebugEnabled()) {
                this.log.debug("matched need has NoHintForMe: {}, NoHintForCounterpart: {}", (Object)matchedNeedNoHintForMe, (Object)matchedNeedNoHintForCounterpart);
                this.log.debug("need will receive a hint: {} (uri: {})", (Object)(!doSuppressHintForNeed ? 1 : 0), (Object)need.getUri());
                this.log.debug("matched need need will receive a hint: {} (uri: {})", (Object)(!doSuppressHintForMatchedNeeds ? 1 : 0), (Object)matchedNeedUri);
                this.log.debug("need matching contexts: {}", matchingContexts);
                this.log.debug("matched need matching contexts: {}", matchedNeedMatchingContexts);
            }
            if (doSuppressHintForNeed && doSuppressHintForMatchedNeeds) {
                this.log.debug("no hints to be sent because of Suppress settings");
                continue;
            }
            String wonNodeUri = this.getFieldValueFirstOfListIfNecessary(doc, WON_NODE_SOLR_FIELD);
            if (wonNodeUri == null) {
                this.log.debug("omitting matched need {}: could not extract WoN node URI", (Object)matchedNeedUri);
                continue;
            }
            double score = Double.valueOf(doc.getFieldValue("score").toString()) * (double)this.config.getScoreNormalizationFactor();
            score = Math.max(0.0, Math.min(1.0, score));
            this.log.debug("generate hint for match {} with normalized score {}", (Object)matchedNeedUri, (Object)score);
            if (!doSuppressHintForNeed) {
                bulkHintEvent.addHintEvent(new HintEvent(need.getWonNodeUri(), need.getUri(), wonNodeUri, matchedNeedUri, this.config.getSolrServerPublicUri(), score));
            }
            if (doSuppressHintForMatchedNeeds) continue;
            bulkHintEvent.addHintEvent(new HintEvent(wonNodeUri, matchedNeedUri, need.getWonNodeUri(), need.getUri(), this.config.getSolrServerPublicUri(), score));
        }
        return bulkHintEvent;
    }

    private List<String> getValueList(SolrDocument document, String fieldName) {
        Object value = document.getFieldValue(fieldName);
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof String) {
            return Arrays.asList((String)value);
        }
        if (value instanceof List) {
            return ((List)value).stream().map(x -> x.toString()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private String getFieldValueFirstOfListIfNecessary(SolrDocument doc, String field) {
        Object value = doc.getFieldValue(field);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof List) {
            return ((List)value).get(0).toString();
        }
        return null;
    }
}

