/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.solr.actor;

import akka.actor.ActorSystem;
import akka.actor.OneForOneStrategy;
import akka.actor.SupervisorStrategy;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.japi.Function;
import com.github.jsonldjava.core.JsonLdError;
import java.io.IOException;
import java.time.temporal.ChronoUnit;
import java.util.LinkedList;
import org.apache.jena.query.Dataset;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrDocumentList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import scala.concurrent.duration.Duration;
import won.matcher.service.common.event.BulkHintEvent;
import won.matcher.service.common.event.BulkNeedEvent;
import won.matcher.service.common.event.NeedEvent;
import won.matcher.solr.config.SolrMatcherConfig;
import won.matcher.solr.hints.HintBuilder;
import won.matcher.solr.index.NeedIndexer;
import won.matcher.solr.query.DefaultMatcherQueryExecuter;
import won.matcher.solr.query.TestMatcherQueryExecutor;
import won.matcher.solr.query.factory.BasicNeedQueryFactory;
import won.matcher.solr.query.factory.BooleanQueryFactory;
import won.matcher.solr.query.factory.CreationDateQueryFactory;
import won.matcher.solr.query.factory.DefaultNeedQueryFactory;
import won.matcher.solr.query.factory.HasFlagQueryFactory;
import won.matcher.solr.query.factory.MatchingContextQueryFactory;
import won.matcher.solr.query.factory.NeedStateQueryFactory;
import won.matcher.solr.query.factory.WhatsAroundQueryFactory;
import won.matcher.solr.query.factory.WhatsNewQueryFactory;
import won.protocol.util.NeedModelWrapper;
import won.protocol.vocabulary.WON;

@Component
@Scope(value="prototype")
public class SolrMatcherActor
extends UntypedActor {
    private LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    @Autowired
    private SolrMatcherConfig config;
    @Autowired
    private HintBuilder hintBuilder;
    @Autowired
    private NeedIndexer needIndexer;
    @Autowired
    @Qualifier(value="defaultMatcherQueryExecuter")
    DefaultMatcherQueryExecuter defaultQueryExecuter;
    @Autowired
    TestMatcherQueryExecutor testQueryExecuter;

    public void onReceive(Object o) throws Exception {
        if (o instanceof NeedEvent) {
            NeedEvent needEvent = (NeedEvent)o;
            if (needEvent.getEventType().equals((Object)NeedEvent.TYPE.ACTIVE)) {
                this.processActiveNeedEvent(needEvent);
            } else if (needEvent.getEventType().equals((Object)NeedEvent.TYPE.INACTIVE)) {
                this.processInactiveNeedEvent(needEvent);
            } else {
                this.unhandled(o);
            }
        } else if (o instanceof BulkNeedEvent) {
            this.log.info("received bulk need event, processing {} need events ...", (Object)((BulkNeedEvent)o).getNeedEvents().size());
            for (NeedEvent event : ((BulkNeedEvent)o).getNeedEvents()) {
                this.processActiveNeedEvent(event);
            }
        } else {
            this.unhandled(o);
        }
    }

    protected void processInactiveNeedEvent(NeedEvent needEvent) throws IOException, JsonLdError {
        this.log.info("Add inactive need event content {} to solr index", (Object)needEvent);
        this.needIndexer.index(needEvent.deserializeNeedDataset());
    }

    protected void processActiveNeedEvent(NeedEvent needEvent) throws IOException, SolrServerException, JsonLdError {
        SolrDocumentList docs;
        BasicNeedQueryFactory qf;
        this.log.info("Start processing active need event {}", (Object)needEvent);
        Dataset dataset = needEvent.deserializeNeedDataset();
        NeedModelWrapper needModelWrapper = new NeedModelWrapper(dataset);
        if (needModelWrapper.hasFlag(WON.NO_HINT_FOR_ME) && needModelWrapper.hasFlag(WON.NO_HINT_FOR_COUNTERPART)) {
            this.log.info("Discarding received need due to flags won:NoHintForMe and won:NoHintForCounterpart: {}", (Object)needEvent);
            return;
        }
        boolean usedForTesting = needModelWrapper.hasFlag(WON.USED_FOR_TESTING);
        DefaultMatcherQueryExecuter queryExecutor = usedForTesting ? this.testQueryExecuter : this.defaultQueryExecuter;
        String queryString = null;
        if (needModelWrapper.hasFlag(WON.WHATS_AROUND)) {
            qf = new WhatsAroundQueryFactory(dataset);
            queryString = qf.createQuery();
        } else if (needModelWrapper.hasFlag(WON.WHATS_NEW)) {
            qf = new WhatsNewQueryFactory(dataset);
            queryString = qf.createQuery();
        } else {
            qf = new DefaultNeedQueryFactory(dataset);
            queryString = qf.createQuery();
        }
        LinkedList<String> filterQueries = new LinkedList<String>();
        filterQueries.add(new NeedStateQueryFactory(dataset).createQuery());
        filterQueries.add(new CreationDateQueryFactory(dataset, 1L, ChronoUnit.MONTHS).createQuery());
        filterQueries.add(new BooleanQueryFactory(BooleanQueryFactory.BooleanOperator.NOT, new HasFlagQueryFactory(HasFlagQueryFactory.FLAGS.NO_HINT_FOR_COUNTERPART)).createQuery());
        if (needModelWrapper.getMatchingContexts() != null && needModelWrapper.getMatchingContexts().size() > 0) {
            filterQueries.add(new MatchingContextQueryFactory(needModelWrapper.getMatchingContexts()).createQuery());
        }
        if (!needModelWrapper.hasFlag(WON.NO_HINT_FOR_ME)) {
            this.log.info("query Solr endpoint {} for need {} and need list 1 (without NoHintForCounterpart)", (Object)this.config.getSolrEndpointUri(usedForTesting), (Object)needEvent.getUri());
            docs = queryExecutor.executeNeedQuery(queryString, this.config.getMaxHints(), null, filterQueries.toArray(new String[filterQueries.size()]));
            if (docs != null) {
                boolean kneeDetection = !needModelWrapper.hasFlag(WON.WHATS_NEW) && !needModelWrapper.hasFlag(WON.WHATS_AROUND);
                BulkHintEvent events = this.hintBuilder.generateHintsFromSearchResult(docs, needEvent, needModelWrapper, false, true, kneeDetection);
                this.log.info("Create {} hints for need {} and need list 1 (without NoHintForCounterpart)", (Object)events.getHintEvents().size(), (Object)needEvent);
                if (events.getHintEvents().size() != 0) {
                    this.getSender().tell((Object)events, this.getSelf());
                }
            } else {
                this.log.warning("No results found for need list 1 (without NoHintForCounterpart) query of need ", (Object)needEvent);
            }
        }
        filterQueries = new LinkedList();
        filterQueries.add(new NeedStateQueryFactory(dataset).createQuery());
        filterQueries.add(new CreationDateQueryFactory(dataset, 1L, ChronoUnit.MONTHS).createQuery());
        filterQueries.add(new BooleanQueryFactory(BooleanQueryFactory.BooleanOperator.NOT, new HasFlagQueryFactory(HasFlagQueryFactory.FLAGS.NO_HINT_FOR_ME)).createQuery());
        filterQueries.add(new BooleanQueryFactory(BooleanQueryFactory.BooleanOperator.NOT, new HasFlagQueryFactory(HasFlagQueryFactory.FLAGS.WHATS_AROUND)).createQuery());
        filterQueries.add(new BooleanQueryFactory(BooleanQueryFactory.BooleanOperator.NOT, new HasFlagQueryFactory(HasFlagQueryFactory.FLAGS.WHATS_NEW)).createQuery());
        if (needModelWrapper.getMatchingContexts() != null && needModelWrapper.getMatchingContexts().size() > 0) {
            filterQueries.add(new MatchingContextQueryFactory(needModelWrapper.getMatchingContexts()).createQuery());
        }
        if (!needModelWrapper.hasFlag(WON.NO_HINT_FOR_COUNTERPART)) {
            this.log.info("query Solr endpoint {} for need {} and need list 2 (without NoHintForSelf, excluding WhatsAround needs)", (Object)this.config.getSolrEndpointUri(usedForTesting), (Object)needEvent.getUri());
            docs = queryExecutor.executeNeedQuery(queryString, this.config.getMaxHintsForCounterparts(), null, filterQueries.toArray(new String[filterQueries.size()]));
            if (docs != null) {
                BulkHintEvent events = this.hintBuilder.generateHintsFromSearchResult(docs, needEvent, needModelWrapper, true, false, true);
                this.log.info("Create {} hints for need {} and need list 2 (without NoHintForSelf, excluding WhatsAround needs)", (Object)events.getHintEvents().size(), (Object)needEvent);
                if (events.getHintEvents().size() != 0) {
                    this.getSender().tell((Object)events, this.getSelf());
                }
            } else {
                this.log.warning("No results found for need list 2 (without NoHintForSelf, excluding WhatsAround needs) query of need ", (Object)needEvent);
            }
        }
        filterQueries = new LinkedList();
        filterQueries.add(new NeedStateQueryFactory(dataset).createQuery());
        filterQueries.add(new CreationDateQueryFactory(dataset, 1L, ChronoUnit.MONTHS).createQuery());
        filterQueries.add(new BooleanQueryFactory(BooleanQueryFactory.BooleanOperator.NOT, new HasFlagQueryFactory(HasFlagQueryFactory.FLAGS.NO_HINT_FOR_ME)).createQuery());
        filterQueries.add(new BooleanQueryFactory(BooleanQueryFactory.BooleanOperator.OR, new HasFlagQueryFactory(HasFlagQueryFactory.FLAGS.WHATS_AROUND), new HasFlagQueryFactory(HasFlagQueryFactory.FLAGS.WHATS_NEW)).createQuery());
        if (needModelWrapper.getMatchingContexts() != null && needModelWrapper.getMatchingContexts().size() > 0) {
            filterQueries.add(new MatchingContextQueryFactory(needModelWrapper.getMatchingContexts()).createQuery());
        }
        if (!needModelWrapper.hasFlag(WON.NO_HINT_FOR_COUNTERPART)) {
            queryString = new WhatsAroundQueryFactory(dataset).createQuery();
            this.log.info("query Solr endpoint {} for need {} and need list 3 (without NoHintForSelf that are only WhatsAround needs)", (Object)this.config.getSolrEndpointUri(usedForTesting), (Object)needEvent.getUri());
            docs = queryExecutor.executeNeedQuery(queryString, this.config.getMaxHintsForCounterparts(), null, filterQueries.toArray(new String[filterQueries.size()]));
            if (docs != null) {
                BulkHintEvent events = this.hintBuilder.generateHintsFromSearchResult(docs, needEvent, needModelWrapper, true, false, false);
                this.log.info("Create {} hints for need {} and need list 3 (without NoHintForSelf that are only WhatsAround needs)", (Object)events.getHintEvents().size(), (Object)needEvent);
                if (events.getHintEvents().size() != 0) {
                    this.getSender().tell((Object)events, this.getSelf());
                }
            } else {
                this.log.warning("No results found for need list 3 (without NoHintForSelf that are only WhatsAround needs) query of need ", (Object)needEvent);
            }
        }
        this.log.info("Add need event content {} to solr index", (Object)needEvent);
        this.needIndexer.index(dataset);
    }

    public SupervisorStrategy supervisorStrategy() {
        OneForOneStrategy supervisorStrategy = new OneForOneStrategy(0, (Duration)Duration.Zero(), (Function)new Function<Throwable, SupervisorStrategy.Directive>(){

            public SupervisorStrategy.Directive apply(Throwable t) throws Exception {
                SolrMatcherActor.this.log.warning("Actor encountered error: {}", (Object)t);
                return SupervisorStrategy.escalate();
            }
        });
        return supervisorStrategy;
    }
}

