/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.rematch.service;

import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import won.matcher.service.common.event.AtomEvent;
import won.matcher.service.common.event.BulkAtomEvent;
import won.matcher.service.common.event.Cause;
import won.matcher.service.common.service.sparql.SparqlService;
import won.matcher.service.crawler.config.CrawlConfig;
import won.protocol.util.AtomModelWrapper;
import won.protocol.util.linkeddata.LinkedDataSource;

@Component
public class RematchSparqlService
extends SparqlService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String HTTP_HEADER_SEPARATOR = ", ";
    @Autowired
    LinkedDataSource linkedDataSource;
    @Autowired
    private CrawlConfig config;

    @Autowired
    public RematchSparqlService(@Value(value="${uri.sparql.endpoint}") String sparqlEndpoint) {
        super(sparqlEndpoint);
    }

    public void registerMatchingAttempt(AtomEvent msg) {
        this.createMatchAttemptUpdate(msg).ifPresent(updateString -> this.executeUpdateQuery((String)updateString));
    }

    public void registerMatchingAttempts(BulkAtomEvent msg) {
        StringBuilder builder = new StringBuilder();
        msg.getAtomEvents().stream().map(e -> this.createMatchAttemptUpdate((AtomEvent)e)).forEach(upd -> upd.ifPresent(updateString -> builder.append((String)updateString)));
        this.executeUpdateQuery(builder.toString());
    }

    private Optional<String> createMatchAttemptUpdate(AtomEvent msg) {
        if (msg.getEventType() == AtomEvent.TYPE.INACTIVE) {
            return Optional.empty();
        }
        StringBuilder builder = new StringBuilder();
        if (msg.getCause() == Cause.PUSHED) {
            builder.append(" DELETE {  \n");
            builder.append("  graph won:rematchMetadata {  \n");
            builder.append("    ?atomUri won:referenceDate ?refDate ; \n");
            builder.append("  } \n");
            builder.append(" } \n");
            builder.append(" WHERE {  \n");
            builder.append("  graph won:rematchMetadata {  \n");
            builder.append("    ?atomUri won:referenceDate ?refDate . \n");
            builder.append("  } \n");
            builder.append(" }; \n");
        }
        builder.append(" INSERT DATA {  \n");
        builder.append("  graph won:rematchMetadata { \n");
        builder.append("      ?atomUri won:matchAttemptDate ?matchAttemptDate; \n");
        builder.append("                  won:referenceDate ?referenceDate. \n");
        builder.append("           \n");
        builder.append("     } \n");
        builder.append(" }; \n");
        builder.append(" DELETE {  \n");
        builder.append("  graph won:rematchMetadata {  \n");
        builder.append("    ?atomUri won:matchAttemptDate ?olderMAD ; \n");
        builder.append("         won:referenceDate ?newerRD ; \n");
        builder.append("  } \n");
        builder.append(" } \n");
        builder.append(" WHERE  \n");
        builder.append(" {  \n");
        builder.append("  graph won:rematchMetadata {  \n");
        builder.append("    ?atomUri won:matchAttemptDate ?newerMAD; \n");
        builder.append("         won:referenceDate ?olderRD . \n");
        builder.append("    optional { \n");
        builder.append("      ?atomUri won:matchAttemptDate ?olderMAD  \n");
        builder.append("      filter (?olderMAD < ?newerMAD) \n");
        builder.append("    } \n");
        builder.append("    optional { \n");
        builder.append("      ?atomUri won:referenceDate ?newerRD \n");
        builder.append("      filter (?olderRD < ?newerRD) \n");
        builder.append("    } \n");
        builder.append("    filter (bound(?newerRD) && bound (?olderMAD)) \n");
        builder.append("  } \n");
        builder.append(" }; \n");
        builder.append("  \n");
        ParameterizedSparqlString pss = new ParameterizedSparqlString();
        pss.setCommandText(builder.toString());
        pss.setNsPrefix("won", "https://w3id.org/won/core#");
        pss.setIri("atomUri", msg.getUri());
        long now = System.currentTimeMillis();
        pss.setLiteral("matchAttemptDate", now);
        pss.setLiteral("referenceDate", now);
        return Optional.of(pss.toString());
    }

    private Set<String> commaConcatenatedStringToSet(String contatenatedString) {
        if (contatenatedString == null || contatenatedString.isEmpty()) {
            return null;
        }
        String[] splitValues = StringUtils.split((String)contatenatedString, (String)HTTP_HEADER_SEPARATOR);
        if (splitValues == null) {
            return new HashSet<String>(Arrays.asList(contatenatedString));
        }
        return new HashSet<String>(Arrays.asList(splitValues));
    }

    public BulkAtomEvent findAtomsForRematching() {
        logger.debug("searching atoms for rematching");
        StringBuilder builder = new StringBuilder();
        builder.append(" prefix won: <https://w3id.org/won/core#> \n");
        builder.append(" select distinct ?atomUri where {  \n");
        builder.append("    graph won:rematchMetadata { \n");
        builder.append("        ?atomUri won:referenceDate ?rDate ; \n");
        builder.append("                  won:matchAttemptDate ?mDate . \n");
        builder.append("         filter (?mDate >= ?rDate) \n");
        builder.append("         bind (?mDate - ?rDate as ?lastDiff) \n");
        builder.append("         bind (?now - ?rDate as ?diff) \n");
        builder.append("     } \n");
        builder.append("  \n");
        builder.append("     filter(?diff > 2 * ?lastDiff) \n");
        builder.append(" } \n");
        ParameterizedSparqlString pps = new ParameterizedSparqlString();
        pps.setNsPrefix("won", "https://w3id.org/won/core#");
        pps.setCommandText(builder.toString());
        pps.setLiteral("now", System.currentTimeMillis());
        BulkAtomEvent bulkAtomEvent = new BulkAtomEvent();
        try (QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.sparqlEndpoint, (Query)pps.asQuery());){
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                String atomUri = qs.get("atomUri").asResource().getURI();
                Dataset ds = this.linkedDataSource.getDataForResource(URI.create(atomUri));
                if (!AtomModelWrapper.isAAtom((Dataset)ds)) continue;
                StringWriter sw = new StringWriter();
                RDFDataMgr.write((StringWriter)sw, (Dataset)ds, (Lang)RDFFormat.TRIG.getLang());
                AtomEvent atomEvent = new AtomEvent(atomUri, null, AtomEvent.TYPE.ACTIVE, System.currentTimeMillis(), sw.toString(), RDFFormat.TRIG.getLang(), Cause.SCHEDULED_FOR_REMATCH);
                bulkAtomEvent.addAtomEvent(atomEvent);
            }
        }
        logger.debug("atomEvents for rematching: " + bulkAtomEvent.getAtomEvents().size());
        return bulkAtomEvent;
    }

    public void setLinkedDataSource(LinkedDataSource linkedDataSource) {
        this.linkedDataSource = linkedDataSource;
    }
}

