/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.rematch.actor;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.net.URI;
import java.util.Optional;
import org.apache.jena.query.Dataset;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import scala.concurrent.ExecutionContext;
import won.matcher.service.common.event.AtomEvent;
import won.matcher.service.common.event.AtomHintEvent;
import won.matcher.service.common.event.BulkAtomEvent;
import won.matcher.service.common.event.BulkHintEvent;
import won.matcher.service.common.event.Cause;
import won.matcher.service.common.event.HintEvent;
import won.matcher.service.common.event.SocketHintEvent;
import won.matcher.service.rematch.config.RematchConfig;
import won.matcher.service.rematch.service.RematchSparqlService;
import won.protocol.util.linkeddata.LinkedDataSource;
import won.protocol.util.linkeddata.WonLinkedDataUtils;

@Component
@Scope(value="prototype")
public class RematchActor
extends UntypedActor {
    private LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private static final String REMATCH_TICK = "rematch_tick";
    private ActorRef pubSubMediator;
    @Autowired
    private RematchSparqlService rematchSparqlService;
    @Autowired
    RematchConfig config;
    @Autowired
    LinkedDataSource linkedDataSource;

    public void setConfig(RematchConfig config) {
        this.config = config;
    }

    public void preStart() {
        this.getContext().system().scheduler().schedule(this.config.getRematchInterval(), this.config.getRematchInterval(), this.getSelf(), (Object)REMATCH_TICK, (ExecutionContext)this.getContext().dispatcher(), null);
        this.pubSubMediator = DistributedPubSub.get((ActorSystem)this.getContext().system()).mediator();
        this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Subscribe(HintEvent.class.getName(), this.getSelf()), this.getSelf());
        this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Subscribe(BulkHintEvent.class.getName(), this.getSelf()), this.getSelf());
        this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Subscribe(AtomEvent.class.getName(), this.getSelf()), this.getSelf());
        this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Subscribe(BulkAtomEvent.class.getName(), this.getSelf()), this.getSelf());
        this.log.debug("RematchActor startup complete");
    }

    public void onReceive(Object msg) throws Throwable {
        if (msg instanceof HintEvent) {
            this.handleHintEvent((HintEvent)msg);
            return;
        }
        if (msg instanceof BulkHintEvent) {
            this.handleBulkHintEvent((BulkHintEvent)msg);
            return;
        }
        if (msg instanceof AtomEvent) {
            this.handleAtomEvent((AtomEvent)msg);
            return;
        }
        if (msg instanceof BulkAtomEvent) {
            this.handleBulkAtomEvent((BulkAtomEvent)msg);
            return;
        }
        if (msg.equals(REMATCH_TICK)) {
            this.rematch();
            return;
        }
        this.unhandled(msg);
    }

    private void rematch() {
        BulkAtomEvent rematchEvent = this.rematchSparqlService.findAtomsForRematching();
        if (!rematchEvent.getAtomEvents().isEmpty()) {
            this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Publish(rematchEvent.getClass().getName(), (Object)rematchEvent), this.getSelf());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Found " + rematchEvent.getAtomEvents().size() + " atoms for rematching");
        }
    }

    private void handleAtomEvent(AtomEvent msg) {
        this.rematchSparqlService.registerMatchingAttempt(msg);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handled AtomEvent: " + msg.getUri(), (Object)(", cause: " + (Object)((Object)msg.getCause())));
        }
    }

    private void handleBulkAtomEvent(BulkAtomEvent msg) {
        this.rematchSparqlService.registerMatchingAttempts(msg);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handled BulkAtomEvent of size " + msg.getAtomEvents().size());
        }
    }

    private void handleBulkHintEvent(BulkHintEvent msg) {
        BulkAtomEvent bulkAtomEvent = new BulkAtomEvent();
        msg.getHintEvents().stream().map(m -> this.processHint((HintEvent)m)).forEach(ae -> ae.ifPresent(x -> bulkAtomEvent.addAtomEvent((AtomEvent)x)));
        if (!bulkAtomEvent.getAtomEvents().isEmpty()) {
            this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Publish(bulkAtomEvent.getClass().getName(), (Object)bulkAtomEvent), this.getSelf());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handled BulkHintEvent of size " + msg.getHintEvents().size());
        }
    }

    private void handleHintEvent(HintEvent msg) {
        this.processHint(msg).ifPresent(e -> this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Publish(e.getClass().getName(), e), this.getSelf()));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handled HintEvent: " + msg);
        }
    }

    private Optional<AtomEvent> processHint(HintEvent msg) {
        if (msg.getCause() == Cause.MATCHED) {
            return Optional.empty();
        }
        Optional<URI> targetAtom = null;
        String targetWonNode = msg.getTargetWonNodeUri();
        if (msg instanceof SocketHintEvent) {
            targetAtom = WonLinkedDataUtils.getAtomOfSocket((URI)URI.create(((SocketHintEvent)msg).getTargetSocketUri()), (LinkedDataSource)this.linkedDataSource);
        } else if (msg instanceof AtomHintEvent) {
            targetAtom = Optional.of(URI.create(((AtomHintEvent)msg).getTargetAtomUri()));
        }
        if (!targetAtom.isPresent()) {
            return Optional.empty();
        }
        Dataset ds = this.linkedDataSource.getDataForResource(targetAtom.get());
        return Optional.of(new AtomEvent(targetAtom.get().toString(), targetWonNode, AtomEvent.TYPE.ACTIVE, System.currentTimeMillis(), ds, Cause.MATCHED));
    }
}

