/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.nodemanager.service;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import won.matcher.service.common.service.sparql.SparqlService;
import won.protocol.exception.DataIntegrityException;
import won.protocol.service.WonNodeInfo;
import won.protocol.util.WonRdfUtils;
import won.protocol.vocabulary.WON;

@Component
public class WonNodeSparqlService
extends SparqlService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Autowired
    public WonNodeSparqlService(@Value(value="${uri.sparql.endpoint}") String sparqlEndpoint) {
        super(sparqlEndpoint);
    }

    public Set<WonNodeInfo> retrieveAllWonNodeInfo() {
        HashSet<WonNodeInfo> wonNodeInfos = new HashSet<WonNodeInfo>();
        String queryString = "SELECT ?graphUri ?nodeUri WHERE { GRAPH ?graphUri {?nodeUri won:uriPrefixSpecification ?c} }";
        ParameterizedSparqlString pps = new ParameterizedSparqlString();
        pps.setCommandText(queryString);
        pps.setNsPrefix("won", "https://w3id.org/won/core#");
        logger.debug("Query SPARQL Endpoint: {}", (Object)this.sparqlEndpoint);
        logger.debug("Execute query: {}", (Object)pps.toString());
        try (QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.sparqlEndpoint, (Query)pps.asQuery());){
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                RDFNode rdfNode = qs.get("graphUri");
                if (rdfNode == null) continue;
                String graphUri = rdfNode.asResource().getURI();
                Dataset ds = this.retrieveDataset(graphUri);
                WonNodeInfo nodeInfo = this.getWonNodeInfoFromDataset(ds);
                wonNodeInfos.add(nodeInfo);
            }
            HashSet<WonNodeInfo> hashSet = wonNodeInfos;
            return hashSet;
        }
    }

    public WonNodeInfo getWonNodeInfoFromDataset(Dataset ds) {
        String dsWonNodeUri = this.getWonNodeUriFromDataset(ds);
        WonNodeInfo nodeInfo = WonRdfUtils.WonNodeUtils.getWonNodeInfo((URI)URI.create(dsWonNodeUri), (Dataset)ds);
        if (nodeInfo == null) {
            throw new DataIntegrityException("Could not load won node info from dataset with URI: " + dsWonNodeUri);
        }
        return nodeInfo;
    }

    private String getWonNodeUriFromDataset(Dataset ds) {
        Model model;
        if (ds.listNames().hasNext() && (model = ds.getNamedModel((String)ds.listNames().next())).listSubjectsWithProperty(WON.uriPrefixSpecification).hasNext()) {
            return model.listSubjectsWithProperty(WON.uriPrefixSpecification).nextResource().toString();
        }
        return null;
    }
}

