/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.nodemanager.service;

import com.google.common.base.Charsets;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.nio.charset.Charset;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import won.matcher.service.common.event.HintEvent;

@Component
@Scope(value="singleton")
public class HintDBService {
    private BloomFilter savedHints = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)Charsets.UTF_8), (int)100000000, (double)1.0E-4);

    public void saveHint(HintEvent hint) {
        this.savedHints.put((Object)this.getHintIdentificationString(hint));
    }

    public boolean mightHintSaved(HintEvent hint) {
        return this.savedHints.mightContain((Object)this.getHintIdentificationString(hint));
    }

    private String getHintIdentificationString(HintEvent hint) {
        return hint.getIdentifyingString();
    }
}

