/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.nodemanager.actor;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.OneForOneStrategy;
import akka.actor.SupervisorStrategy;
import akka.camel.CamelMessage;
import akka.camel.javaapi.UntypedProducerActor;
import akka.cluster.pubsub.DistributedPubSub;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.japi.Function;
import java.net.URI;
import java.util.HashMap;
import java.util.Optional;
import org.apache.jena.riot.Lang;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import scala.concurrent.duration.Duration;
import won.matcher.service.common.event.AtomHintEvent;
import won.matcher.service.common.event.HintEvent;
import won.matcher.service.common.event.SocketHintEvent;
import won.matcher.service.common.service.monitoring.MonitoringService;
import won.protocol.exception.WonMessageBuilderException;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageBuilder;
import won.protocol.message.WonMessageDirection;
import won.protocol.message.WonMessageEncoder;
import won.protocol.service.WonNodeInformationService;
import won.protocol.util.linkeddata.LinkedDataSource;
import won.protocol.util.linkeddata.WonLinkedDataUtils;

@Component
@Scope(value="prototype")
public class HintProducerProtocolActor
extends UntypedProducerActor {
    @Autowired
    private MonitoringService monitoringService;
    @Autowired
    private WonNodeInformationService wonNodeInformationService;
    @Autowired
    private LinkedDataSource linkedDataSource;
    private String endpoint;
    private String localBrokerUri;
    private ActorRef pubSubMediator;
    private LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));

    public HintProducerProtocolActor(String endpoint, String localBrokerUri) {
        this.endpoint = endpoint;
        this.localBrokerUri = localBrokerUri;
        this.pubSubMediator = DistributedPubSub.get((ActorSystem)this.getContext().system()).mediator();
    }

    public String getEndpointUri() {
        return this.endpoint;
    }

    public Object onTransformOutgoingMessage(Object message) {
        HintEvent hint = (HintEvent)message;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("methodName", "hint");
        URI eventUri = this.wonNodeInformationService.generateEventURI(URI.create(hint.getRecipientWonNodeUri()));
        hint.setGeneratedEventUri(eventUri);
        Optional<WonMessage> wonMessage = this.createHintWonMessage(hint);
        if (wonMessage.isPresent()) {
            String body = WonMessageEncoder.encode((WonMessage)wonMessage.get(), (Lang)Lang.TRIG);
            CamelMessage camelMsg = new CamelMessage((Object)body, headers);
            this.stopStopwatch(hint);
            return camelMsg;
        }
        return null;
    }

    private void stopStopwatch(HintEvent hint) {
        Optional<Object> stopwatchTag = Optional.empty();
        if (hint instanceof AtomHintEvent) {
            stopwatchTag = Optional.of(((AtomHintEvent)hint).getTargetAtomUri());
        } else if (hint instanceof SocketHintEvent) {
            stopwatchTag = Optional.of(((SocketHintEvent)hint).getTargetSocketUri());
        }
        if (stopwatchTag.isPresent()) {
            this.monitoringService.stopClock("AtomReceivedUntilFirstHintSent", (String)stopwatchTag.get());
            this.log.debug("Send hint camel message {}", stopwatchTag.get());
        }
    }

    private Optional<WonMessage> createHintWonMessage(HintEvent hint) throws WonMessageBuilderException {
        SocketHintEvent she;
        Optional recipientAtomURI;
        if (hint instanceof AtomHintEvent) {
            AtomHintEvent ahe = (AtomHintEvent)hint;
            return Optional.of(WonMessageBuilder.setMessagePropertiesForHintToAtom((URI)ahe.getGeneratedEventUri(), (URI)URI.create(ahe.getRecipientAtomUri()), (URI)URI.create(ahe.getRecipientWonNodeUri()), (URI)URI.create(ahe.getTargetAtomUri()), (URI)URI.create(ahe.getMatcherUri()), (double)hint.getScore()).setWonMessageDirection(WonMessageDirection.FROM_EXTERNAL).build());
        }
        if (hint instanceof SocketHintEvent && (recipientAtomURI = WonLinkedDataUtils.getAtomOfSocket((URI)URI.create((she = (SocketHintEvent)hint).getRecipientSocketUri()), (LinkedDataSource)this.linkedDataSource)).isPresent()) {
            return Optional.of(WonMessageBuilder.setMessagePropertiesForHintToSocket((URI)she.getGeneratedEventUri(), (URI)((URI)recipientAtomURI.get()), (URI)URI.create(she.getRecipientSocketUri()), (URI)URI.create(she.getRecipientWonNodeUri()), (URI)URI.create(she.getTargetSocketUri()), (URI)URI.create(she.getMatcherUri()), (double)hint.getScore()).setWonMessageDirection(WonMessageDirection.FROM_EXTERNAL).build());
        }
        return Optional.empty();
    }

    public SupervisorStrategy supervisorStrategy() {
        OneForOneStrategy supervisorStrategy = new OneForOneStrategy(0, (Duration)Duration.Zero(), (Function)new Function<Throwable, SupervisorStrategy.Directive>(){

            public SupervisorStrategy.Directive apply(Throwable t) throws Exception {
                HintProducerProtocolActor.this.log.warning("Actor encountered error: {}", (Object)t);
                return SupervisorStrategy.escalate();
            }
        });
        return supervisorStrategy;
    }
}

