/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.nodemanager.actor;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.OneForOneStrategy;
import akka.actor.SupervisorStrategy;
import akka.camel.CamelMessage;
import akka.camel.javaapi.UntypedConsumerActor;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.japi.Function;
import java.net.URI;
import org.apache.jena.query.Dataset;
import org.apache.jena.riot.Lang;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import scala.concurrent.duration.Duration;
import won.matcher.service.common.event.AtomEvent;
import won.matcher.service.common.event.Cause;
import won.matcher.service.common.service.monitoring.MonitoringService;
import won.matcher.service.crawler.msg.CrawlUriMessage;
import won.matcher.service.crawler.msg.ResourceCrawlUriMessage;
import won.protocol.util.AtomModelWrapper;
import won.protocol.util.linkeddata.LinkedDataSource;

@Component
@Scope(value="prototype")
public class AtomConsumerProtocolActor
extends UntypedConsumerActor {
    private static final String MSG_HEADER_METHODNAME = "methodName";
    private static final String MSG_HEADER_METHODNAME_ATOMCREATED = "atomCreated";
    private static final String MSG_HEADER_METHODNAME_ATOMMODIFIED = "atomModified";
    private static final String MSG_HEADER_METHODNAME_ATOMACTIVATED = "atomActivated";
    private static final String MSG_HEADER_METHODNAME_ATOMDEACTIVATED = "atomDeactivated";
    private static final String MSG_HEADER_WON_NODE_URI = "wonNodeURI";
    private static final String MSG_HEADER_ATOM_URI = "atomURI";
    private final String endpoint;
    private ActorRef pubSubMediator;
    private LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    @Autowired
    private MonitoringService monitoringService;
    @Autowired
    private LinkedDataSource linkedDataSource;

    public AtomConsumerProtocolActor(String endpoint) {
        this.endpoint = endpoint;
        this.pubSubMediator = DistributedPubSub.get((ActorSystem)this.getContext().system()).mediator();
    }

    public String getEndpointUri() {
        return this.endpoint;
    }

    public void onReceive(Object message) throws Exception {
        if (message instanceof CamelMessage) {
            CamelMessage camelMsg = (CamelMessage)message;
            String atomUri = (String)camelMsg.getHeaders().get(MSG_HEADER_ATOM_URI);
            String wonNodeUri = (String)camelMsg.getHeaders().get(MSG_HEADER_WON_NODE_URI);
            this.monitoringService.startClock("AtomReceivedUntilFirstHintSent", atomUri);
            if (atomUri != null && wonNodeUri != null) {
                Object methodName = camelMsg.getHeaders().get(MSG_HEADER_METHODNAME);
                if (methodName != null) {
                    this.log.debug("Received event '{}' for atomUri '{}' and wonAtomUri '{}' and publish it to matchers", methodName, (Object)atomUri, (Object)wonNodeUri);
                    AtomEvent event = null;
                    long crawlDate = System.currentTimeMillis();
                    Dataset ds = this.linkedDataSource.getDataForResource(URI.create(atomUri));
                    if (AtomModelWrapper.isAAtom((Dataset)ds)) {
                        if (methodName.equals(MSG_HEADER_METHODNAME_ATOMCREATED)) {
                            event = new AtomEvent(atomUri, wonNodeUri, AtomEvent.TYPE.ACTIVE, crawlDate, ds, Cause.PUSHED);
                            this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Publish(event.getClass().getName(), (Object)event), this.getSelf());
                        } else if (methodName.equals(MSG_HEADER_METHODNAME_ATOMMODIFIED)) {
                            event = new AtomEvent(atomUri, wonNodeUri, AtomEvent.TYPE.ACTIVE, crawlDate, ds, Cause.PUSHED);
                            this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Publish(event.getClass().getName(), (Object)event), this.getSelf());
                        } else if (methodName.equals(MSG_HEADER_METHODNAME_ATOMACTIVATED)) {
                            event = new AtomEvent(atomUri, wonNodeUri, AtomEvent.TYPE.ACTIVE, crawlDate, ds, Cause.PUSHED);
                            this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Publish(event.getClass().getName(), (Object)event), this.getSelf());
                        } else if (methodName.equals(MSG_HEADER_METHODNAME_ATOMDEACTIVATED)) {
                            event = new AtomEvent(atomUri, wonNodeUri, AtomEvent.TYPE.INACTIVE, crawlDate, ds, Cause.PUSHED);
                            this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Publish(event.getClass().getName(), (Object)event), this.getSelf());
                        } else {
                            this.unhandled(message);
                        }
                        ResourceCrawlUriMessage resMsg = new ResourceCrawlUriMessage(atomUri, atomUri, wonNodeUri, CrawlUriMessage.STATUS.SAVE, crawlDate, null);
                        resMsg.setSerializedResource(camelMsg.body().toString());
                        resMsg.setSerializationFormat(Lang.TRIG);
                        this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Publish(resMsg.getClass().getName(), (Object)resMsg), this.getSelf());
                        return;
                    }
                } else {
                    this.log.warning("Message not processed; methodName is null");
                }
            } else {
                this.log.warning("Message not processed; atomURI or wonNodeURI is null");
            }
        }
        this.unhandled(message);
    }

    public SupervisorStrategy supervisorStrategy() {
        OneForOneStrategy supervisorStrategy = new OneForOneStrategy(0, (Duration)Duration.Zero(), (Function)new Function<Throwable, SupervisorStrategy.Directive>(){

            public SupervisorStrategy.Directive apply(Throwable t) throws Exception {
                AtomConsumerProtocolActor.this.log.warning("Actor encountered error: {}", (Object)t);
                return SupervisorStrategy.escalate();
            }
        });
        return supervisorStrategy;
    }
}

