/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.crawler.service;

import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import won.matcher.service.common.event.AtomEvent;
import won.matcher.service.common.event.BulkAtomEvent;
import won.matcher.service.common.event.Cause;
import won.matcher.service.common.service.sparql.SparqlService;
import won.matcher.service.crawler.config.CrawlConfig;
import won.matcher.service.crawler.msg.CrawlUriMessage;
import won.protocol.util.AtomModelWrapper;

@Component
public class CrawlSparqlService
extends SparqlService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String HTTP_HEADER_SEPARATOR = ", ";
    @Autowired
    private CrawlConfig config;

    @Autowired
    public CrawlSparqlService(@Value(value="${uri.sparql.endpoint}") String sparqlEndpoint) {
        super(sparqlEndpoint);
    }

    public void updateCrawlingMetadata(CrawlUriMessage msg) {
        this.executeUpdateQuery(this.createUpdateCrawlingMetadataQuery(msg));
    }

    public void bulkUpdateCrawlingMetadata(Collection<CrawlUriMessage> msgs) {
        StringBuilder builder = new StringBuilder();
        for (CrawlUriMessage msg : msgs) {
            builder.append(this.createUpdateCrawlingMetadataQuery(msg));
        }
        this.executeUpdateQuery(builder.toString());
    }

    private String createUpdateCrawlingMetadataQuery(CrawlUriMessage msg) {
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE WHERE { GRAPH won:crawlMetadata { ?msgUri ?y ?z}};\n");
        builder.append("\nINSERT DATA { GRAPH won:crawlMetadata {\n");
        builder.append("?msgUri won:crawlDate ?crawlDate.\n");
        builder.append("?msgUri won:crawlStatus ?crawlStatus.\n");
        builder.append("?msgUri won:crawlBaseUri ?crawlBaseUri.\n");
        if (msg.getWonNodeUri() != null) {
            builder.append("?msgUri won:wonNodeUri ?wonNodeUri.\n");
        }
        if (msg.getResourceETagHeaderValues() != null && !msg.getResourceETagHeaderValues().isEmpty()) {
            for (int i = 0; i < msg.getResourceETagHeaderValues().size(); ++i) {
                builder.append("?msgUri won:resourceETagValue ? .\n");
            }
        }
        builder.append("}};\n");
        ParameterizedSparqlString pss = new ParameterizedSparqlString();
        pss.setCommandText(builder.toString());
        pss.setNsPrefix("won", "https://w3id.org/won/core#");
        pss.setIri("msgUri", msg.getUri());
        pss.setLiteral("crawlDate", msg.getCrawlDate());
        pss.setLiteral("crawlStatus", msg.getStatus().toString());
        pss.setIri("crawlBaseUri", msg.getBaseUri());
        if (msg.getWonNodeUri() != null) {
            pss.setIri("wonNodeUri", msg.getWonNodeUri());
        }
        if (msg.getResourceETagHeaderValues() != null && !msg.getResourceETagHeaderValues().isEmpty()) {
            int i = 0;
            for (String etagValue : msg.getResourceETagHeaderValues()) {
                pss.setLiteral(i, etagValue);
                ++i;
            }
        }
        return pss.toString();
    }

    private Set<String> commaConcatenatedStringToSet(String contatenatedString) {
        if (contatenatedString == null || contatenatedString.isEmpty()) {
            return null;
        }
        String[] splitValues = StringUtils.split((String)contatenatedString, (String)HTTP_HEADER_SEPARATOR);
        if (splitValues == null) {
            return new HashSet<String>(Arrays.asList(contatenatedString));
        }
        return new HashSet<String>(Arrays.asList(splitValues));
    }

    public Set<CrawlUriMessage> retrieveMessagesForCrawling(CrawlUriMessage.STATUS status) {
        LinkedHashSet<CrawlUriMessage> msgs = new LinkedHashSet<CrawlUriMessage>();
        String queryString = "SELECT ?uri ?base ?wonNode (group_concat(distinct ?etag;separator=\", \") as ?etags) WHERE { GRAPH won:crawlMetadata {\n ?uri ?p ?status.\n ?uri won:crawlBaseUri ?base.\n OPTIONAL { ?uri won:wonNodeUri ?wonNode }\n OPTIONAL { ?uri won:resourceETagValue ?etag }}}\n GROUP BY ?uri ?base ?wonNode\n";
        ParameterizedSparqlString pps = new ParameterizedSparqlString();
        pps.setNsPrefix("won", "https://w3id.org/won/core#");
        pps.setCommandText(queryString);
        pps.setLiteral("status", status.toString());
        logger.debug("Query SPARQL Endpoint: {}", (Object)this.sparqlEndpoint);
        logger.debug("Execute query: {}", (Object)pps.toString());
        try (QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.sparqlEndpoint, (Query)pps.asQuery());){
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                String uri = qs.get("uri").asResource().getURI();
                String baseUri = qs.get("base").asResource().getURI();
                CrawlUriMessage msg = null;
                String wonNode = null;
                Set<String> etags = null;
                if (qs.get("wonNode") != null) {
                    wonNode = qs.get("wonNode").asResource().getURI();
                }
                if (qs.get("etags") != null) {
                    String etagsString = qs.get("etags").asLiteral().getString();
                    etags = this.commaConcatenatedStringToSet(etagsString);
                }
                msg = new CrawlUriMessage(uri, baseUri, wonNode, CrawlUriMessage.STATUS.PROCESS, System.currentTimeMillis(), etags);
                logger.debug("Created message: {}", (Object)msg);
                msgs.add(msg);
            }
            LinkedHashSet<CrawlUriMessage> linkedHashSet = msgs;
            return linkedHashSet;
        }
    }

    public Set<CrawlUriMessage> extractCrawlUriMessages(String baseUri, String wonNodeUri) {
        Set<CrawlUriMessage> msgs;
        HashSet<CrawlUriMessage> newCrawlMessages = new HashSet<CrawlUriMessage>();
        for (String prop : this.config.getCrawlNonBasePropertyPaths()) {
            msgs = this.extractCrawlUriMessagesForPropertyPath(baseUri, wonNodeUri, prop, false);
            if (msgs == null) continue;
            newCrawlMessages.addAll(msgs);
        }
        for (String prop : this.config.getCrawlBasePropertyPaths()) {
            msgs = this.extractCrawlUriMessagesForPropertyPath(baseUri, wonNodeUri, prop, true);
            if (msgs == null) continue;
            newCrawlMessages.addAll(msgs);
        }
        return newCrawlMessages;
    }

    private Set<CrawlUriMessage> extractCrawlUriMessagesForPropertyPath(String baseUri, String wonNodeUri, String propertyPath, boolean baseProperty) {
        if (propertyPath.trim().length() == 0) {
            return null;
        }
        HashSet<CrawlUriMessage> newCrawlMessages = new HashSet<CrawlUriMessage>();
        long crawlDate = System.currentTimeMillis();
        String queryString = "SELECT ?uri (group_concat(distinct ?etag;separator=\", \") as ?etags) WHERE {\n{ ?baseUriWithTrailingSlash " + propertyPath + " ?uri. } \nUNION { ?baseUriWithoutTrailingSlash " + propertyPath + " ?uri. } \n OPTIONAL {?uri won:resourceETagValue ?etag. }}\n GROUP BY ?uri\n";
        ParameterizedSparqlString pps = new ParameterizedSparqlString();
        pps.setNsPrefix("won", "https://w3id.org/won/core#");
        pps.setCommandText(queryString);
        baseUri = baseUri.trim();
        if (baseUri.endsWith("/")) {
            baseUri = baseUri.substring(0, baseUri.length() - 1);
        }
        pps.setIri("baseUriWithoutTrailingSlash", baseUri);
        pps.setIri("baseUriWithTrailingSlash", baseUri + "/");
        logger.debug("Query SPARQL Endpoint: {}", (Object)this.sparqlEndpoint);
        logger.debug("Execute query: {}", (Object)pps.toString());
        try (QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.sparqlEndpoint, (Query)pps.asQuery());){
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                String extractedUri = qs.get("uri").asResource().getURI();
                Set<String> etags = null;
                if (qs.get("etags") != null) {
                    String etagsString = qs.get("etags").asLiteral().getString();
                    etags = this.commaConcatenatedStringToSet(etagsString);
                }
                CrawlUriMessage newUriMsg = null;
                logger.debug("Extracted URI: {}", (Object)extractedUri);
                newUriMsg = baseProperty ? new CrawlUriMessage(extractedUri, extractedUri, wonNodeUri, CrawlUriMessage.STATUS.PROCESS, crawlDate, etags) : new CrawlUriMessage(extractedUri, baseUri, wonNodeUri, CrawlUriMessage.STATUS.PROCESS, crawlDate, etags);
                newCrawlMessages.add(newUriMsg);
            }
            HashSet<CrawlUriMessage> hashSet = newCrawlMessages;
            return hashSet;
        }
    }

    public String retrieveAtomModificationDateForCrawling(String wonNodeUri) {
        String queryString = "SELECT ?modificationDate WHERE {\n ?atomUri a won:Atom.\n ?atomUri won:wonNode ?wonNodeUri. \n ?atomUri dcterms:modified ?modificationDate. \n ?atomUri won:crawlStatus 'DONE'. \n} ORDER BY DESC(?modificationDate) LIMIT 1\n";
        ParameterizedSparqlString pps = new ParameterizedSparqlString();
        pps.setNsPrefix("won", "https://w3id.org/won/core#");
        pps.setNsPrefix("dcterms", "http://purl.org/dc/terms/");
        pps.setCommandText(queryString);
        pps.setIri("wonNodeUri", wonNodeUri);
        try (QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.sparqlEndpoint, (Query)pps.asQuery());){
            ResultSet results = qexec.execSelect();
            String modificationDate = null;
            if (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                modificationDate = qs.get("modificationDate").asLiteral().getString();
            }
            String string = modificationDate;
            return string;
        }
    }

    public String retrieveConnectionModificationDateForCrawling(String wonNodeUri) {
        String queryString = "SELECT ?modificationDate WHERE {\n ?connectionUri a won:Connection.\n ?connectionUri won:wonNode ?wonNodeUri. \n ?connectionUri dcterms:modified ?modificationDate. \n ?connectionUri won:crawlStatus 'DONE'. \n} ORDER BY DESC(?modificationDate) LIMIT 1\n";
        ParameterizedSparqlString pps = new ParameterizedSparqlString();
        pps.setNsPrefix("won", "https://w3id.org/won/core#");
        pps.setNsPrefix("dcterms", "http://purl.org/dc/terms/");
        pps.setCommandText(queryString);
        pps.setIri("wonNodeUri", wonNodeUri);
        try (QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.sparqlEndpoint, (Query)pps.asQuery());){
            ResultSet results = qexec.execSelect();
            String modificationDate = null;
            if (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                modificationDate = qs.get("modificationDate").asLiteral().getString();
            }
            String string = modificationDate;
            return string;
        }
    }

    public BulkAtomEvent retrieveActiveAtomEvents(long fromDate, long toDate, int offset, int limit, boolean sortAscending) {
        String orderClause = sortAscending ? "ORDER BY ?date\n" : "ORDER BY DESC(?date)\n";
        logger.debug("bulk load atom data from sparql endpoint in date range: [{},{}]", (Object)fromDate, (Object)toDate);
        String queryTemplate = "SELECT ?atomUri ?wonNodeUri ?date WHERE {  \n  ?atomUri a won:Atom. \n  ?atomUri won:crawlDate ?date.  \n  ?atomUri won:atomState won:Active. \n  ?atomUri won:wonNode ?wonNodeUri. \n  {?atomUri won:crawlStatus 'SAVE'.} UNION {?atomUri won:crawlStatus 'DONE'.}\n  FILTER (?date >= ?fromDate && ?date < ?toDate ) \n} " + orderClause + " OFFSET ?offset\n LIMIT ?limit";
        ParameterizedSparqlString pps = new ParameterizedSparqlString();
        pps.setNsPrefix("won", "https://w3id.org/won/core#");
        pps.setCommandText(queryTemplate);
        pps.setLiteral("fromDate", fromDate);
        pps.setLiteral("toDate", toDate);
        pps.setLiteral("offset", offset);
        pps.setLiteral("limit", limit);
        logger.debug("Query SPARQL Endpoint: {}", (Object)this.sparqlEndpoint);
        logger.debug("Execute query: {}", (Object)pps.toString());
        try (QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.sparqlEndpoint, (Query)pps.asQuery());){
            ResultSet results = qexec.execSelect();
            BulkAtomEvent bulkAtomEvent = new BulkAtomEvent();
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                String atomUri = qs.get("atomUri").asResource().getURI();
                String wonNodeUri = qs.get("wonNodeUri").asResource().getURI();
                long crawlDate = qs.getLiteral("date").getLong();
                Dataset ds = this.retrieveAtomDataset(atomUri);
                if (!AtomModelWrapper.isAAtom((Dataset)ds)) continue;
                StringWriter sw = new StringWriter();
                RDFDataMgr.write((StringWriter)sw, (Dataset)ds, (Lang)RDFFormat.TRIG.getLang());
                AtomEvent atomEvent = new AtomEvent(atomUri, wonNodeUri, AtomEvent.TYPE.ACTIVE, crawlDate, sw.toString(), RDFFormat.TRIG.getLang(), Cause.CRAWLED);
                bulkAtomEvent.addAtomEvent(atomEvent);
            }
            logger.debug("number of atom events created: " + bulkAtomEvent.getAtomEvents().size());
            BulkAtomEvent bulkAtomEvent2 = bulkAtomEvent;
            return bulkAtomEvent2;
        }
    }
}

