/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.crawler.msg;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;

public class CrawlUriMessage
implements Serializable {
    private String uri;
    private String baseUri;
    private String wonNodeUri;
    private STATUS status;
    private long crawlDate;
    private Collection<String> resourceETagHeaderValues;

    public CrawlUriMessage(String uri, String baseUri, String wonNodeUri, STATUS status, long crawlDate, Collection<String> etags) {
        this.uri = uri;
        this.baseUri = baseUri;
        this.status = status;
        this.wonNodeUri = wonNodeUri;
        this.crawlDate = crawlDate;
        this.resourceETagHeaderValues = etags != null ? Collections.unmodifiableCollection(etags) : null;
    }

    public String getUri() {
        return this.uri;
    }

    public STATUS getStatus() {
        return this.status;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public String getWonNodeUri() {
        return this.wonNodeUri;
    }

    public long getCrawlDate() {
        return this.crawlDate;
    }

    public Collection<String> getResourceETagHeaderValues() {
        return this.resourceETagHeaderValues;
    }

    public String toString() {
        String etags = this.getResourceETagHeaderValues() != null ? String.join((CharSequence)", ", this.getResourceETagHeaderValues()) : "<None>";
        return "[" + this.uri + "," + this.baseUri + "," + this.wonNodeUri + "," + (Object)((Object)this.status) + "," + this.crawlDate + ", " + etags + "]";
    }

    public CrawlUriMessage clone() {
        return new CrawlUriMessage(this.uri, this.baseUri, this.wonNodeUri, this.status, this.crawlDate, this.resourceETagHeaderValues);
    }

    public boolean equals(Object obj) {
        CrawlUriMessage msg;
        if (obj instanceof CrawlUriMessage && this.uri.equals((msg = (CrawlUriMessage)obj).getUri()) && this.baseUri.equals(msg.getBaseUri()) && this.status.equals((Object)msg.getStatus()) && this.crawlDate == msg.getCrawlDate()) {
            return this.wonNodeUri == null ? msg.getWonNodeUri() == null : this.wonNodeUri.equals(msg.getWonNodeUri());
        }
        return false;
    }

    public int hashCode() {
        return (this.uri + this.baseUri + this.wonNodeUri + this.status.toString() + this.crawlDate).hashCode();
    }

    public static enum STATUS {
        PROCESS,
        FAILED,
        DONE,
        SAVE;

    }
}

