/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.crawler.actor;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import won.matcher.service.common.event.BulkAtomEvent;
import won.matcher.service.common.event.LoadAtomEvent;
import won.matcher.service.crawler.service.CrawlSparqlService;

@Component
@Scope(value="prototype")
public class AtomEventLoaderActor
extends UntypedActor {
    private static int MAX_BULK_SIZE = 10;
    private LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private ActorRef pubSubMediator;
    @Autowired
    private CrawlSparqlService sparqlService;

    public void preStart() {
        this.pubSubMediator = DistributedPubSub.get((ActorSystem)this.getContext().system()).mediator();
        this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Subscribe(LoadAtomEvent.class.getName(), this.getSelf()), this.getSelf());
    }

    public void onReceive(Object o) throws Throwable {
        if (o instanceof LoadAtomEvent) {
            BulkAtomEvent bulkAtomEvent;
            LoadAtomEvent msg = (LoadAtomEvent)o;
            this.log.debug("received request to load atoms events: {}", (Object)msg);
            int offset = 0;
            do {
                if ((bulkAtomEvent = msg.getLastXAtomEvents() == -1 ? this.sparqlService.retrieveActiveAtomEvents(msg.getFromDate(), msg.getToDate(), offset, MAX_BULK_SIZE, true) : this.sparqlService.retrieveActiveAtomEvents(0L, Long.MAX_VALUE, offset, Math.min(MAX_BULK_SIZE, msg.getLastXAtomEvents() - offset), false)).getAtomEvents().size() <= 0) continue;
                this.log.debug("send bulk event of size {} back to requesting actor", (Object)bulkAtomEvent.getAtomEvents().size());
                this.getSender().tell((Object)bulkAtomEvent, this.getSelf());
                offset += bulkAtomEvent.getAtomEvents().size();
            } while (bulkAtomEvent.getAtomEvents().size() == MAX_BULK_SIZE);
        }
    }
}

