/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.common.service.sparql;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.expr.nodevalue.NodeValueBoolean;
import org.apache.jena.sparql.modify.UpdateProcessRemote;
import org.apache.jena.tdb.TDB;
import org.apache.jena.tdb.TDBFactory;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import won.protocol.util.RdfUtils;

@Component
public class SparqlService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected String sparqlEndpoint;

    public static Dataset deserializeDataset(String serializedResource, Lang format) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(serializedResource.getBytes(StandardCharsets.UTF_8));
        Dataset ds = RdfUtils.toDataset((InputStream)is, (RDFFormat)new RDFFormat(format));
        ((InputStream)is).close();
        return ds;
    }

    @Autowired
    public SparqlService(@Value(value="${uri.sparql.endpoint}") String sparqlEndpoint) {
        this.sparqlEndpoint = sparqlEndpoint;
    }

    public String getSparqlEndpoint() {
        return this.sparqlEndpoint;
    }

    public String createUpdateNamedGraphQuery(String graph, Model model) {
        StringWriter sw = new StringWriter();
        RDFDataMgr.write((StringWriter)sw, (Model)model, (Lang)Lang.NTRIPLES);
        String query = "\nCLEAR GRAPH ?g;\n\nINSERT DATA { GRAPH ?g { " + sw + "}};\n";
        ParameterizedSparqlString pps = new ParameterizedSparqlString();
        pps.setCommandText(query);
        pps.setIri("g", graph);
        return pps.toString();
    }

    public void updateNamedGraphsOfDataset(Dataset ds) {
        String query = "";
        Iterator graphNames = ds.listNames();
        while (graphNames.hasNext()) {
            logger.debug("Save dataset");
            String graphName = (String)graphNames.next();
            Model model = ds.getNamedModel(graphName);
            query = query + this.createUpdateNamedGraphQuery(graphName, model);
        }
        if (query != "") {
            this.executeUpdateQuery(query);
        }
    }

    public Model retrieveModel(String graphName) {
        String queryTemplate = "CONSTRUCT { ?s ?p ?o } WHERE { GRAPH ?g { ?s ?p ?o } . }";
        ParameterizedSparqlString pps = new ParameterizedSparqlString();
        pps.setCommandText(queryTemplate);
        pps.setIri("g", graphName);
        Query query = QueryFactory.create((String)pps.toString());
        try (QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.sparqlEndpoint, (Query)query);){
            Model model;
            Model model2 = model = qexec.execConstruct();
            return model2;
        }
    }

    public Dataset retrieveDataset(String graphName) {
        DatasetGraph dsg = TDBFactory.createDatasetGraph();
        dsg.getContext().set(TDB.symUnionDefaultGraph, (Object)new NodeValueBoolean(true));
        Dataset ds = DatasetFactory.create((DatasetGraph)dsg);
        Model model = this.retrieveModel(graphName);
        ds.addNamedModel(graphName, model);
        return ds;
    }

    public Dataset retrieveAtomDataset(String uri) {
        String queryString = "prefix won: <https://w3id.org/won/core#> select distinct ?g where { GRAPH ?g { ?uri a won:Atom. ?a ?b ?c. } }";
        ParameterizedSparqlString pps = new ParameterizedSparqlString();
        pps.setCommandText(queryString);
        pps.setIri("uri", uri);
        Query query = QueryFactory.create((String)pps.toString());
        try (QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.sparqlEndpoint, (Query)query);){
            ResultSet results = qexec.execSelect();
            Dataset ds = DatasetFactory.createGeneral();
            while (results.hasNext()) {
                QuerySolution qs = results.next();
                String graphUri = qs.getResource("g").getURI();
                Model model = this.retrieveModel(graphUri);
                ds.addNamedModel(graphUri, model);
            }
            Dataset dataset = ds;
            return dataset;
        }
    }

    public void executeUpdateQuery(String updateQuery) {
        try {
            logger.debug("Update SPARQL Endpoint: {}", (Object)this.sparqlEndpoint);
            logger.debug("Execute query: {}", (Object)updateQuery);
            UpdateRequest query = UpdateFactory.create((String)updateQuery);
            UpdateProcessRemote riStore = (UpdateProcessRemote)UpdateExecutionFactory.createRemote((UpdateRequest)query, (String)this.sparqlEndpoint);
            riStore.execute();
        }
        catch (QueryParseException e) {
            logger.warn("Error parsing update query: " + updateQuery, (Throwable)e);
        }
    }
}

