/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.common.service.monitoring;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class MonitoringService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ATOM_HINT_STOPWATCH = "AtomReceivedUntilFirstHintSent";
    private Map<String, Map<String, Split>> stopWatchSplits = new HashMap<String, Map<String, Split>>();
    @Value(value="${matcher.service.monitoring}")
    private boolean monitoringEnabled;

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public void startClock(String stopWatchName, String splitName) {
        if (this.isMonitoringEnabled()) {
            Map<String, Split> splits = this.stopWatchSplits.get(stopWatchName);
            if (splits == null) {
                splits = new HashMap<String, Split>();
                this.stopWatchSplits.put(stopWatchName, splits);
            }
            if (splits.get(splitName) != null) {
                logger.warn("Split '{}' in stopwatch {} already set for monitoring start event", (Object)splitName, (Object)stopWatchName);
                return;
            }
            Stopwatch stopwatch = SimonManager.getStopwatch((String)stopWatchName);
            Split split = stopwatch.start();
            splits.put(splitName, split);
        }
    }

    public void stopClock(String stopWatchName, String splitName) {
        if (this.isMonitoringEnabled()) {
            Map<String, Split> splits = this.stopWatchSplits.get(stopWatchName);
            if (splits == null) {
                logger.warn("No stopwatch '{}' found for monitoring end event", (Object)stopWatchName);
                return;
            }
            Split split = splits.get(splitName);
            if (split == null) {
                logger.warn("No split '{}' in stopwatch '{}' found for monitoring end event", (Object)splitName, (Object)stopWatchName);
                return;
            }
            split.stop();
        }
    }
}

