/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.common.event;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import org.apache.jena.query.Dataset;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.LangBuilder;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import won.matcher.service.common.event.Cause;
import won.matcher.service.common.service.sparql.SparqlService;

public class AtomEvent
implements Serializable {
    private String uri;
    private String wonNodeUri;
    private String serializedAtomResource;
    private String serializationLangName;
    private String serializationLangContentType;
    private long crawlDate;
    private TYPE eventType;
    private Cause cause;

    public AtomEvent(String uri, String wonNodeUri, TYPE eventType, long crawlDate, String resource, Lang format, Cause cause) {
        this.uri = uri;
        this.wonNodeUri = wonNodeUri;
        this.eventType = eventType;
        this.crawlDate = crawlDate;
        this.serializedAtomResource = resource;
        this.serializationLangName = format.getName();
        this.serializationLangContentType = format.getContentType().getContentType();
        this.cause = cause;
    }

    public AtomEvent(String uri, String wonNodeUri, TYPE eventType, long crawlDate, Dataset ds, Cause cause) {
        this.uri = uri;
        this.wonNodeUri = wonNodeUri;
        this.eventType = eventType;
        this.crawlDate = crawlDate;
        StringWriter sw = new StringWriter();
        RDFDataMgr.write((StringWriter)sw, (Dataset)ds, (Lang)RDFFormat.TRIG.getLang());
        this.serializedAtomResource = sw.toString();
        this.serializationLangName = RDFFormat.TRIG.getLang().getName();
        this.serializationLangContentType = RDFFormat.TRIG.getLang().getContentType().getContentType();
        this.cause = cause;
    }

    public String getUri() {
        return this.uri;
    }

    public String getWonNodeUri() {
        return this.wonNodeUri;
    }

    public TYPE getEventType() {
        return this.eventType;
    }

    public Cause getCause() {
        return this.cause;
    }

    public String getSerializedAtomResource() {
        return this.serializedAtomResource;
    }

    public Lang getSerializationFormat() {
        Lang format = LangBuilder.create((String)this.serializationLangName, (String)this.serializationLangContentType).build();
        return format;
    }

    public long getCrawlDate() {
        return this.crawlDate;
    }

    public Dataset deserializeAtomDataset() throws IOException {
        return SparqlService.deserializeDataset(this.serializedAtomResource, this.getSerializationFormat());
    }

    public AtomEvent clone() {
        AtomEvent e = new AtomEvent(this.uri, this.wonNodeUri, this.eventType, this.crawlDate, this.serializedAtomResource, this.getSerializationFormat(), this.cause);
        return e;
    }

    public String toString() {
        return this.getUri();
    }

    public static enum TYPE {
        ACTIVE,
        INACTIVE;

    }
}

