/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.nodemanager.config;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

@Configuration
@PropertySource(value={"file:${WON_CONFIG_DIR}/matcher-service.properties"})
public class WonNodeControllerConfig {
    @Value(value="#{'${wonNodeController.wonNode.crawl}'.split(',')}")
    private List<String> crawlWonNodes;
    @Value(value="#{'${wonNodeController.wonNode.skip}'.split(',')}")
    private List<String> skipWonNodes;
    @Value(value="${wonNodeController.wonNode.lifeCheckDuration}")
    private long lifeCheckDuration;

    public FiniteDuration getLifeCheckDuration() {
        return Duration.create((long)this.lifeCheckDuration, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public List<String> getSkipWonNodes() {
        return this.skipWonNodes;
    }

    public List<String> getCrawlWonNodes() {
        return this.crawlWonNodes;
    }
}

