/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.nodemanager.actor;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.OneForOneStrategy;
import akka.actor.SupervisorStrategy;
import akka.camel.CamelMessage;
import akka.camel.javaapi.UntypedProducerActor;
import akka.cluster.pubsub.DistributedPubSub;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.japi.Function;
import java.net.URI;
import java.util.HashMap;
import org.apache.jena.riot.Lang;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import scala.concurrent.duration.Duration;
import won.matcher.service.common.event.HintEvent;
import won.matcher.service.common.service.monitoring.MonitoringService;
import won.protocol.exception.WonMessageBuilderException;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageBuilder;
import won.protocol.message.WonMessageDirection;
import won.protocol.message.WonMessageEncoder;
import won.protocol.model.FacetType;

@Component
@Scope(value="prototype")
public class HintProducerProtocolActor
extends UntypedProducerActor {
    @Autowired
    private MonitoringService monitoringService;
    private String endpoint;
    private String localBrokerUri;
    private ActorRef pubSubMediator;
    private LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));

    public HintProducerProtocolActor(String endpoint, String localBrokerUri) {
        this.endpoint = endpoint;
        this.localBrokerUri = localBrokerUri;
        this.pubSubMediator = DistributedPubSub.get((ActorSystem)this.getContext().system()).mediator();
    }

    public String getEndpointUri() {
        return this.endpoint;
    }

    public Object onTransformOutgoingMessage(Object message) {
        HintEvent hint = (HintEvent)message;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("needURI", hint.getFromNeedUri());
        headers.put("otherNeedURI", hint.getToNeedUri());
        headers.put("score", String.valueOf(hint.getScore()));
        headers.put("originator", hint.getMatcherUri());
        headers.put("methodName", "hint");
        WonMessage wonMessage = this.createHintWonMessage(hint);
        String body = WonMessageEncoder.encode((WonMessage)wonMessage, (Lang)Lang.TRIG);
        CamelMessage camelMsg = new CamelMessage((Object)body, headers);
        this.monitoringService.stopClock("NeedReceivedUntilFirstHintSent", hint.getFromNeedUri());
        this.log.debug("Send hint camel message {}", (Object)hint.getFromNeedUri());
        return camelMsg;
    }

    private WonMessage createHintWonMessage(HintEvent hint) throws WonMessageBuilderException {
        URI wonNode = URI.create(hint.getFromWonNodeUri());
        return WonMessageBuilder.setMessagePropertiesForHint((URI)hint.getGeneratedEventUri(), (URI)URI.create(hint.getFromNeedUri()), (URI)FacetType.OwnerFacet.getURI(), (URI)wonNode, (URI)URI.create(hint.getToNeedUri()), (URI)FacetType.OwnerFacet.getURI(), (URI)URI.create(hint.getMatcherUri()), (double)hint.getScore()).setWonMessageDirection(WonMessageDirection.FROM_EXTERNAL).build();
    }

    public SupervisorStrategy supervisorStrategy() {
        OneForOneStrategy supervisorStrategy = new OneForOneStrategy(0, (Duration)Duration.Zero(), (Function)new Function<Throwable, SupervisorStrategy.Directive>(){

            public SupervisorStrategy.Directive apply(Throwable t) throws Exception {
                HintProducerProtocolActor.this.log.warning("Actor encountered error: {}", (Object)t);
                return SupervisorStrategy.escalate();
            }
        });
        return supervisorStrategy;
    }
}

