/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.crawler.config;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

@Configuration
@PropertySource(value={"file:${WON_CONFIG_DIR}/matcher-service.properties"})
public class CrawlConfig {
    @Value(value="#{'${crawler.propertyPaths.base}'.split(',')}")
    private List<String> crawlBasePropertyPaths;
    @Value(value="#{'${crawler.propertyPaths.nonBase}'.split(',')}")
    private List<String> crawlNonBasePropertyPaths;
    @Value(value="${crawler.http.timeout.connection}")
    private long httpConnectionTimeout;
    @Value(value="${crawler.http.timeout.read}")
    private long httpReadTimeout;
    @Value(value="${crawler.metaDataUpdate.maxDuration}")
    private long metaDataUpdateMaxDuration;
    @Value(value="${crawler.metaDataUpdate.maxBulkSize}")
    private long metaDataUpdateMaxBulkSize;
    @Value(value="${crawler.recrawl.interval.minutes}")
    private long recrawlIntervalMinutes;

    public List<String> getCrawlBasePropertyPaths() {
        return this.crawlBasePropertyPaths;
    }

    public List<String> getCrawlNonBasePropertyPaths() {
        return this.crawlNonBasePropertyPaths;
    }

    public long getHttpConnectionTimeout() {
        return this.httpConnectionTimeout;
    }

    public long getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    public FiniteDuration getRecrawlIntervalDuration() {
        return Duration.create((long)this.recrawlIntervalMinutes, (TimeUnit)TimeUnit.MINUTES);
    }

    public FiniteDuration getMetaDataUpdateMaxDuration() {
        return Duration.create((long)this.metaDataUpdateMaxDuration, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public long getMetaDataUpdateMaxBulkSize() {
        return this.metaDataUpdateMaxBulkSize;
    }
}

