/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.common.event;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import org.apache.jena.query.Dataset;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.LangBuilder;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import won.matcher.service.common.service.sparql.SparqlService;

public class NeedEvent
implements Serializable {
    private String uri;
    private String wonNodeUri;
    private String serializedNeedResource;
    private String serializationLangName;
    private String serializationLangContentType;
    private long crawlDate;
    private TYPE eventType;

    public NeedEvent(String uri, String wonNodeUri, TYPE eventType, long crawlDate, String resource, Lang format) {
        this.uri = uri;
        this.wonNodeUri = wonNodeUri;
        this.eventType = eventType;
        this.crawlDate = crawlDate;
        this.serializedNeedResource = resource;
        this.serializationLangName = format.getName();
        this.serializationLangContentType = format.getContentType().getContentType();
    }

    public NeedEvent(String uri, String wonNodeUri, TYPE eventType, long crawlDate, Dataset ds) {
        this.uri = uri;
        this.wonNodeUri = wonNodeUri;
        this.eventType = eventType;
        this.crawlDate = crawlDate;
        StringWriter sw = new StringWriter();
        RDFDataMgr.write((StringWriter)sw, (Dataset)ds, (Lang)RDFFormat.TRIG.getLang());
        this.serializedNeedResource = sw.toString();
        this.serializationLangName = RDFFormat.TRIG.getLang().getName();
        this.serializationLangContentType = RDFFormat.TRIG.getLang().getContentType().getContentType();
    }

    public String getUri() {
        return this.uri;
    }

    public String getWonNodeUri() {
        return this.wonNodeUri;
    }

    public TYPE getEventType() {
        return this.eventType;
    }

    public String getSerializedNeedResource() {
        return this.serializedNeedResource;
    }

    public Lang getSerializationFormat() {
        Lang format = LangBuilder.create((String)this.serializationLangName, (String)this.serializationLangContentType).build();
        return format;
    }

    public long getCrawlDate() {
        return this.crawlDate;
    }

    public Dataset deserializeNeedDataset() throws IOException {
        return SparqlService.deserializeDataset(this.serializedNeedResource, this.getSerializationFormat());
    }

    public NeedEvent clone() {
        NeedEvent e = new NeedEvent(this.uri, this.wonNodeUri, this.eventType, this.crawlDate, this.serializedNeedResource, this.getSerializationFormat());
        return e;
    }

    public String toString() {
        return this.getUri();
    }

    public static enum TYPE {
        ACTIVE,
        INACTIVE;

    }
}

